/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.session;

import java.util.List;
import nexcore.sprout.spring.boot.autoconfigure.session.RedisSessionRegistry;
import org.springframework.security.core.session.SessionInformation;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.authentication.session.ConcurrentSessionControlAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;

public class RedisConcurrentSessionControlAuthenticationStrategy
extends ConcurrentSessionControlAuthenticationStrategy {
    private RedisSessionRegistry sessionRegistry;

    public RedisConcurrentSessionControlAuthenticationStrategy(SessionRegistry sessionRegistry) {
        super(sessionRegistry);
        this.sessionRegistry = (RedisSessionRegistry)sessionRegistry;
    }

    protected void allowableSessionsExceeded(List<SessionInformation> sessions, int allowableSessions, SessionRegistry registry) throws SessionAuthenticationException {
        SessionInformation leastRecentlyUsed = null;
        for (SessionInformation session : sessions) {
            if (leastRecentlyUsed != null && !session.getLastRequest().before(leastRecentlyUsed.getLastRequest())) continue;
            leastRecentlyUsed = session;
        }
        leastRecentlyUsed.expireNow();
        this.sessionRegistry.removeSessionInformation(leastRecentlyUsed.getSessionId());
    }
}

