/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.resourcebundle;

import javax.sql.DataSource;
import nexcore.sprout.foundry.resourcebundle.message.DBReloadableResourceBundleMessageSource;
import nexcore.sprout.foundry.resourcebundle.message.ReloadableResourceBundleMessageSource;
import nexcore.sprout.spring.boot.autoconfigure.jdbc.SproutDataSourceAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.resourcebundle.MessageSourceAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.resourcebundle.MessageSourceProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MessageSourceProperties.MessageDataSourceProperties.class})
@AutoConfigureBefore(value={MessageSourceAutoConfiguration.class})
@AutoConfigureAfter(value={SproutDataSourceAutoConfiguration.class})
@ConditionalOnMissingBean(value={ReloadableResourceBundleMessageSource.class})
@ConditionalOnProperty(prefix="sprout.message.datasource", name={"enabled"}, havingValue="true")
public class MessageDataSourceAutoConfiguration
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(MessageDataSourceAutoConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private MessageSourceProperties.MessageDataSourceProperties messageDataSourceProperties;

    @Bean
    @ConditionalOnBean(name={"dataSourceForSprout"})
    public DBReloadableResourceBundleMessageSource messageSource() {
        logger.info((Object)"===== MessageSource DataSource Enabled: True");
        DBReloadableResourceBundleMessageSource messageDatasource = new DBReloadableResourceBundleMessageSource();
        messageDatasource.setDataSource((DataSource)this.applicationContext.getBean("dataSourceForSprout"));
        if (this.messageDataSourceProperties.isFallbackToSystemLocale()) {
            messageDatasource.setFallbackToSystemLocale(this.messageDataSourceProperties.isFallbackToSystemLocale());
        }
        if (this.messageDataSourceProperties.getCacheSeconds() != 0) {
            messageDatasource.setCacheSeconds(this.messageDataSourceProperties.getCacheSeconds());
        }
        if (this.messageDataSourceProperties.getQueryCode() != null) {
            messageDatasource.setQueryCode(this.messageDataSourceProperties.getQueryCode());
        }
        if (this.messageDataSourceProperties.getName() != null) {
            messageDatasource.setBeanName(this.messageDataSourceProperties.getName());
        }
        logger.info((Object)"====== Creating MessageSourceForDB.");
        return messageDatasource;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

