/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.resourcebundle;

import javax.sql.DataSource;
import nexcore.sprout.foundry.resourcebundle.code.DBReloadableResourceBundleCodeSource;
import nexcore.sprout.foundry.resourcebundle.code.ReloadableResourceBundleCodeSource;
import nexcore.sprout.spring.boot.autoconfigure.jdbc.SproutDataSourceAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.resourcebundle.CodeSourceAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.resourcebundle.CodeSourceProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={CodeSourceProperties.CodeDataSourceProperties.class})
@AutoConfigureBefore(value={CodeSourceAutoConfiguration.class})
@AutoConfigureAfter(value={SproutDataSourceAutoConfiguration.class})
@ConditionalOnMissingBean(value={ReloadableResourceBundleCodeSource.class})
@ConditionalOnProperty(prefix="sprout.code.datasource", name={"enabled"}, havingValue="true")
public class CodeDataSourceAutoConfiguration
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(CodeDataSourceAutoConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CodeSourceProperties.CodeDataSourceProperties codeDataSourceProperties;

    @Bean
    @ConditionalOnBean(name={"dataSourceForSprout"})
    public DBReloadableResourceBundleCodeSource codeSource() {
        logger.info((Object)"===== CodeSource DataSource Enabled: True");
        DBReloadableResourceBundleCodeSource codeDataSource = new DBReloadableResourceBundleCodeSource();
        codeDataSource.setDataSource((DataSource)this.applicationContext.getBean("dataSourceForSprout"));
        if (this.codeDataSourceProperties.isFallbackToSystemLocale()) {
            codeDataSource.setFallbackToSystemLocale(this.codeDataSourceProperties.isFallbackToSystemLocale());
        }
        if (this.codeDataSourceProperties.getName() != null) {
            codeDataSource.setBeanName(this.codeDataSourceProperties.getName());
        }
        if (this.codeDataSourceProperties.getOrder() != Integer.MAX_VALUE) {
            codeDataSource.setOrder(this.codeDataSourceProperties.getOrder());
        }
        if (this.codeDataSourceProperties.getCacheSeconds() != 0) {
            codeDataSource.setCacheSeconds(this.codeDataSourceProperties.getCacheSeconds());
        }
        if (this.codeDataSourceProperties.getQueryCode() != null) {
            codeDataSource.setQueryCode(this.codeDataSourceProperties.getQueryCode());
        }
        logger.info((Object)"====== Creating CodeSourceForDB.");
        return codeDataSource;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

