/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.log;

import javax.sql.DataSource;
import nexcore.sprout.foundry.log.accesslog.old.AccessLogDbWriterForOldBcm;
import nexcore.sprout.foundry.log.errorlog.ErrorLogDbWriter;
import nexcore.sprout.spring.boot.autoconfigure.jdbc.SproutDataSourceAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.log.AccessLogManagerAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.log.AccessLogProperties;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
@ConditionalOnBean(name={"dataSourceForSprout", "transactionManagerForSprout"})
@EnableConfigurationProperties(value={AccessLogProperties.class, AccessLogProperties.ErrorLogProperties.class})
@AutoConfigureAfter(value={SproutDataSourceAutoConfiguration.class})
@AutoConfigureBefore(value={AccessLogManagerAutoConfiguration.class})
public class AccessLogWriterConfiguration
implements ApplicationContextAware {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private AccessLogProperties accessLogProperties;
    @Autowired
    private AccessLogProperties.ErrorLogProperties errorLogProperties;

    @Bean
    @ConditionalOnBean(name={"dataSourceForSprout", "transactionManagerForSprout"})
    @ConditionalOnMissingClass
    @ConditionalOnProperty(prefix="sprout.access-log", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public AccessLogDbWriterForOldBcm accessLogDbWriter() {
        AccessLogDbWriterForOldBcm accessLogDbWriter = new AccessLogDbWriterForOldBcm();
        accessLogDbWriter.setDataSource((DataSource)this.applicationContext.getBean("dataSourceForSprout", DataSource.class));
        accessLogDbWriter.setTransactionManager((PlatformTransactionManager)this.applicationContext.getBean("transactionManagerForSprout", PlatformTransactionManager.class));
        if (this.accessLogProperties.getInsertQuery() != null) {
            accessLogDbWriter.setInsertQuery(this.accessLogProperties.getInsertQuery());
        }
        if (this.accessLogProperties.isWriteErrorLog()) {
            accessLogDbWriter.setWriteErrorLog(this.accessLogProperties.isWriteErrorLog());
        }
        return accessLogDbWriter;
    }

    @Bean
    @ConditionalOnMissingClass
    @ConditionalOnProperty(prefix="sprout.error-log", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnBean(name={"dataSourceForSprout", "transactionManagerForSprout"})
    public ErrorLogDbWriter errorLogDbWriter() {
        ErrorLogDbWriter errorLogDbWriter = new ErrorLogDbWriter();
        errorLogDbWriter.setDataSource((DataSource)this.applicationContext.getBean("dataSourceForSprout", DataSource.class));
        errorLogDbWriter.setTransactionManager((PlatformTransactionManager)this.applicationContext.getBean("transactionManagerForSprout", PlatformTransactionManager.class));
        if (this.errorLogProperties.getInsertQuery() != null) {
            errorLogDbWriter.setInsertQuery(this.errorLogProperties.getInsertQuery());
        }
        return errorLogDbWriter;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

