/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.log;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nexcore.sprout.foundry.log.accesslog.AccessLogManager;
import nexcore.sprout.foundry.log.accesslog.IAccessLogDataExtractor;
import nexcore.sprout.foundry.log.accesslog.IAccessLogWriter;
import nexcore.sprout.log.monitor.writer.logstash.LogstashAccessLogWriter;
import nexcore.sprout.spring.boot.autoconfigure.jdbc.SproutDataSourceAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.log.monitor.LogMonitorProperties;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mobile.device.DeviceResolver;
import org.springframework.mobile.device.LiteDeviceResolver;

@Configuration
@EnableConfigurationProperties(value={LogMonitorProperties.class})
@AutoConfigureAfter(value={SproutDataSourceAutoConfiguration.class})
public class AccessLogManagerAutoConfiguration {
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Qualifier(value="defaultLogDataExtractor")
    @Autowired
    private IAccessLogDataExtractor accessLogDataExtractor;
    @Autowired
    private LogMonitorProperties logMonitorProperties;

    @Bean
    @ConditionalOnMissingBean(value={AccessLogManager.class})
    @ConditionalOnBean(value={IAccessLogWriter.class})
    public AccessLogManager accessLogManager() {
        AccessLogManager accessLogManager = new AccessLogManager();
        ArrayList<IAccessLogWriter> AccessLogList = new ArrayList<IAccessLogWriter>();
        AccessLogList.addAll(this.findIAccessLogWriter());
        accessLogManager.setAsscessLogWriters(AccessLogList);
        accessLogManager.setAccessLogDataExtractor(this.accessLogDataExtractor);
        return accessLogManager;
    }

    @Bean
    @ConditionalOnProperty(prefix="sprout.log.monitor", name={"enabled"}, havingValue="true")
    @ConditionalOnMissingBean(name={"logstashAccessLogWriter"})
    public LogstashAccessLogWriter logstashAccessLogWriter() {
        LogstashAccessLogWriter logstashAccessLogWriter = new LogstashAccessLogWriter();
        logstashAccessLogWriter.setUseYN(true);
        logstashAccessLogWriter.setDeviceResolver((DeviceResolver)this.applicationContext.getBean(DeviceResolver.class));
        if (this.logMonitorProperties.getServiceName() != null) {
            logstashAccessLogWriter.setServiceGroupName(this.logMonitorProperties.getServiceName());
        }
        if (this.logMonitorProperties.getAccessLoggerName() != null) {
            logstashAccessLogWriter.setLogstashLoggerName(this.logMonitorProperties.getAccessLoggerName());
        }
        if (this.logMonitorProperties.isUseInflowsInfo()) {
            logstashAccessLogWriter.setUseInflowsInfo(this.logMonitorProperties.isUseInflowsInfo());
        }
        return logstashAccessLogWriter;
    }

    @Bean
    @ConditionalOnProperty(prefix="sprout.log.monitor", name={"enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={DeviceResolver.class})
    public DeviceResolver deviceResolver() {
        return new LiteDeviceResolver();
    }

    public List<IAccessLogWriter> findIAccessLogWriter() {
        ArrayList<IAccessLogWriter> iAccessLogWriterList = new ArrayList<IAccessLogWriter>();
        if (this.applicationContext == null) {
            return Collections.emptyList();
        }
        for (IAccessLogWriter iAccessLogWriter : this.getBeans(IAccessLogWriter.class)) {
            iAccessLogWriterList.add(iAccessLogWriter);
        }
        return iAccessLogWriterList;
    }

    private <T> Collection<T> getBeans(Class<T> type) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext.getBeanFactory(), type).values();
    }
}

