/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.jmx;

import javax.management.MBeanServer;
import nexcore.sprout.spring.boot.autoconfigure.jmx.SproutJmxProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.jmx.support.ConnectorServerFactoryBean;
import org.springframework.remoting.rmi.RmiRegistryFactoryBean;

@Configuration
@EnableConfigurationProperties(value={SproutJmxProperties.class})
@ConditionalOnBean(value={MBeanServer.class})
@AutoConfigureAfter(value={JmxAutoConfiguration.class})
@ConditionalOnProperty(prefix="sprout.jmx", name={"enabled"}, havingValue="true")
public class SproutJmxAutoConfiguration {
    @Autowired
    private SproutJmxProperties jmxProperties;
    private static final Log logger = LogFactory.getLog(SproutJmxAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public RmiRegistryFactoryBean rmiRegistry() {
        RmiRegistryFactoryBean rmiRegistry = new RmiRegistryFactoryBean();
        rmiRegistry.setPort(this.jmxProperties.getRmiPort());
        logger.info((Object)("====== Creating Bean: " + this.getClass().toString()));
        return rmiRegistry;
    }

    @Bean
    @DependsOn(value={"rmiRegistry"})
    @ConditionalOnMissingBean
    public ConnectorServerFactoryBean serverConnector() {
        ConnectorServerFactoryBean serverConnector = new ConnectorServerFactoryBean();
        try {
            serverConnector.setObjectName((Object)this.jmxProperties.getConnectorName());
            serverConnector.setServiceUrl(this.jmxProperties.getServiceUrl());
            serverConnector.setThreaded(this.jmxProperties.getThreaded());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.info((Object)("====== Creating Bean: " + this.getClass().toString()));
        return serverConnector;
    }
}

