/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.exception;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nexcore.sprout.foundry.exception.hanlder.ExceptionTranslator;
import nexcore.sprout.foundry.exception.hanlder.web.ModelAndViewExceptionTranslator;
import nexcore.sprout.spring.boot.autoconfigure.exception.SproutExceptionHandlerAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.exception.SproutExceptionProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SproutExceptionProperties.class})
@AutoConfigureBefore(value={SproutExceptionHandlerAutoConfiguration.class})
public class SproutExceptionTranslatorConfiguration
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(SproutExceptionTranslatorConfiguration.class);
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private SproutExceptionProperties exceptionProperties;

    @Bean
    @ConditionalOnMissingBean
    public ModelAndViewExceptionTranslator MVCExceptionTranslator() {
        ModelAndViewExceptionTranslator mvcExceptionTranslator = new ModelAndViewExceptionTranslator();
        if (this.exceptionProperties.getDefaultViewName() != null) {
            mvcExceptionTranslator.setDefaultViewName(this.exceptionProperties.getDefaultViewName());
        }
        if (this.exceptionProperties.isSupportOldVersion()) {
            mvcExceptionTranslator.setSupportOldVersion(this.exceptionProperties.isSupportOldVersion());
        }
        logger.info((Object)("====== Creating Bean: " + mvcExceptionTranslator.getClass().toString()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"====== Properties for Created Bean");
            logger.debug((Object)("====== DefaultViewName: " + this.exceptionProperties.getDefaultViewName()));
        }
        return mvcExceptionTranslator;
    }

    public List<ExceptionTranslator> findExceptionTranslator() {
        ArrayList<ExceptionTranslator> exceptionTranslatorList = new ArrayList<ExceptionTranslator>();
        if (this.applicationContext == null) {
            logger.info((Object)"ExceptionTranslator List is null.");
            return Collections.emptyList();
        }
        exceptionTranslatorList.addAll(this.getBeans(ExceptionTranslator.class));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("====== Find Total ExceptionTranslator: " + exceptionTranslatorList.size()));
            for (ExceptionTranslator exceptionTranslator : exceptionTranslatorList) {
                logger.debug((Object)("====== Find ExceptionTranslator: " + exceptionTranslator.getClass().toString()));
            }
        }
        return exceptionTranslatorList;
    }

    private <T> Collection<T> getBeans(Class<T> type) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext.getBeanFactory(), type).values();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }
}

