/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.exception;

import java.io.IOException;
import nexcore.sprout.foundry.exception.hanlder.ExceptionHandler;
import nexcore.sprout.foundry.exception.hanlder.web.ExceptionResolverComposite;
import nexcore.sprout.spring.boot.autoconfigure.exception.SproutExceptionProperties;
import nexcore.sprout.spring.boot.autoconfigure.exception.SproutExceptionResolverAutoConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Description;
import org.springframework.context.annotation.Profile;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.SimpleMappingExceptionResolver;

@Configuration
@Profile(value={"exception-resolver-composite"})
@ConditionalOnBean(value={ExceptionHandler.class})
@EnableConfigurationProperties(value={SproutExceptionProperties.class})
@AutoConfigureBefore(value={SproutExceptionResolverAutoConfiguration.class})
@Description(value="for Integration with other HandlerExceptionResolver. ex) Default ExceptionResolver, Customized ExceptionResolver")
public class SproutExceptionResolverCompositeAutoConfiguration
extends WebMvcConfigurerAdapter
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(SproutExceptionResolverCompositeAutoConfiguration.class);
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private SproutExceptionProperties exceptionProperties;

    @Bean
    public SimpleMappingExceptionResolver simpleMappingExceptionResolver() {
        SimpleMappingExceptionResolver simpleMappingExceptionResolver = new SimpleMappingExceptionResolver();
        simpleMappingExceptionResolver.setDefaultErrorView(this.exceptionProperties.getDefaultViewName());
        logger.info((Object)("====== Creating Bean: " + simpleMappingExceptionResolver.getClass().toString()));
        logger.info((Object)("====== DefaultViewName for SimpleMappingExceptionResolver: " + this.exceptionProperties.getDefaultViewName()));
        return simpleMappingExceptionResolver;
    }

    @Bean
    @ConditionalOnMissingBean
    public ExceptionResolverComposite exceptionResolver() throws IOException {
        ExceptionResolverComposite exceptionResolver = new ExceptionResolverComposite();
        exceptionResolver.setExceptionHandler((ExceptionHandler)this.applicationContext.getBean(ExceptionHandler.class));
        logger.info((Object)("====== Creating Bean: " + exceptionResolver.getClass().toString()));
        logger.info((Object)("====== ExceptionHandler for ExceptionResolver: " + ((ExceptionHandler)this.applicationContext.getBean(ExceptionHandler.class)).toString()));
        return exceptionResolver;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }
}

