package nexcore.sprout.spring.boot.autoconfigure.webmvc;

import org.springframework.boot.context.properties.ConfigurationProperties;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@ConfigurationProperties(prefix=SproutAutoConfigConst.PREFIX_SPROUT_MVC_COMMON_FIELD_SETTER)
public class CommonFieldSetterProperties {
	/** success Result 코드 값  */
	private String successResultCode;
	/** 1.x BCM UI 지원 여부 */
	private boolean supportOildVersion;
	/** resultCode key 값  */
	private String resultCodeFieldKeyName;
	/** resultMessage key 값  */
	private String resultMessageFieldKeyName;
	/** Mapping Path Patterns  */
	private String[] pathPatterns = {"/**"};
	/** Mapping Exclude Path Patterns  */
	private String[] excludePatterns = {
			"classpath:/META-INF/resources/", "classpath:/resources/",
			"classpath:/static/", "classpath:/public/" };
	
	public String getSuccessResultCode() {
		return successResultCode;
	}
	
	public void setSuccessResultCode(String successResultCode) {
		this.successResultCode = successResultCode;
	}
	
	public boolean isSupportOildVersion() {
		return supportOildVersion;
	}
	
	public void setSupportOildVersion(boolean supportOildVersion) {
		this.supportOildVersion = supportOildVersion;
	}
	
	public String getResultCodeFieldKeyName() {
		return resultCodeFieldKeyName;
	}
	
	public void setResultCodeFieldKeyName(String resultCodeFieldKeyName) {
		this.resultCodeFieldKeyName = resultCodeFieldKeyName;
	}
	
	public String getResultMessageFieldKeyName() {
		return resultMessageFieldKeyName;
	}
	
	public void setResultMessageFieldKeyName(String resultMessageFieldKeyName) {
		this.resultMessageFieldKeyName = resultMessageFieldKeyName;
	}

	public String[] getPathPatterns() {
		return pathPatterns;
	}

	public void setPathPatterns(String[] pathPatterns) {
		this.pathPatterns = pathPatterns;
	}

	public String[] getExcludePatterns() {
		return excludePatterns;
	}

	public void setExcludePatterns(String[] excludePatterns) {
		this.excludePatterns = excludePatterns;
	}
	
}
