package nexcore.sprout.spring.boot.autoconfigure.test;

import java.util.regex.Pattern;

import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScan.Filter;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.filter.RegexPatternTypeFilter;
import org.springframework.test.context.ActiveProfiles;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.ImportResource;

@Configuration
@EnableAutoConfiguration
@ImportResource("${biz.configuration.file.location}")
@ComponentScan(basePackages = "*.*", excludeFilters = {
		@Filter(type = FilterType.CUSTOM, value = { ComponetScanExcludeFilter.class }) })
@ActiveProfiles(value = SproutAutoConfigConst.ACTIVE_PROFILE_NAME_TEST)
public class SpringBootTestApplicationConfiguration { 

}

class ComponetScanExcludeFilter extends RegexPatternTypeFilter {
	//component 스캔시 전체 package 외 spring 및 sprout 관련 내용은 제외하기 위한 filter
	public ComponetScanExcludeFilter() {
		super(Pattern.compile("org.apache.*|nexcore.*|org.springframework.*|org.*"));
	}
}
