package nexcore.sprout.spring.boot.autoconfigure.test;

import org.junit.Before;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.filter.CharacterEncodingFilter;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;


@RunWith(SpringJUnit4ClassRunner.class)
@WebAppConfiguration
@ActiveProfiles(value = SproutAutoConfigConst.ACTIVE_PROFILE_NAME_TEST)
@Rollback
@SpringApplicationConfiguration(classes = SpringBootTestApplicationConfiguration.class)
public class SpringBootControllerTestSupport extends nexcore.sprout.test.support.ControllerTestSupportCore {

	@Autowired
	private WebApplicationContext context;
	
	/**
	 * Constructor
	 */
	public SpringBootControllerTestSupport() {
		super();
	}
	
	
	/**
	 * Build MockMvc
	 */
	@Before
	public void setup() {
		super.setUrlPostfix("json");
		DefaultMockMvcBuilder builder = MockMvcBuilders.webAppContextSetup(context);
		
		/** System Variable Setting */
		System.setProperty("system.id", "localhost");
		
 		/** Filter Setting */
		// filter 설정
		CharacterEncodingFilter cef = new CharacterEncodingFilter();
		cef.setEncoding("UTF-8");
		builder.addFilter(cef,"/*");
		
		mockMvc = builder.build();
	}

}
