package nexcore.sprout.spring.boot.autoconfigure.session;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.session.Session;
import org.springframework.session.web.context.AbstractHttpSessionApplicationInitializer;

import nexcore.sprout.spring.boot.autoconfigure.redis.RedisAutoConfiguration;

@Configuration
@ConditionalOnClass(Session.class)
@AutoConfigureAfter(RedisAutoConfiguration.class)
public class SessionAutoConfiguration extends AbstractHttpSessionApplicationInitializer {

	private static final Log logger = LogFactory.getLog(SessionAutoConfiguration.class);

	@Override
	public void onStartup(ServletContext servletContext) throws ServletException {
		super.onStartup(servletContext);
	}

}