package nexcore.sprout.spring.boot.autoconfigure.security;

import org.springframework.boot.context.properties.ConfigurationProperties;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@ConfigurationProperties(prefix = SproutAutoConfigConst.PREFIX_SPROUT_SECURITY)
public class SproutSecurityProperties {
	
	private SproutSecurityCoreProperties sproutSecurityCoreProperties = new SproutSecurityCoreProperties();
	
	private SproutSecurityFileProperties sproutSecurityFileProperties = new SproutSecurityFileProperties();
	
	private SproutSecurityDbProperties sproutSecurityDbProperties = new SproutSecurityDbProperties();
	
	public SproutSecurityCoreProperties getSproutSecurityCoreProperties() {
		return sproutSecurityCoreProperties;
	}

	public void setSproutSecurityCoreProperties(SproutSecurityCoreProperties sproutSecurityCoreProperties) {
		this.sproutSecurityCoreProperties = sproutSecurityCoreProperties;
	}

	public SproutSecurityFileProperties getSproutSecurityFileProperties() {
		return sproutSecurityFileProperties;
	}

	public void setSproutSecurityFileProperties(SproutSecurityFileProperties sproutSecurityFileProperties) {
		this.sproutSecurityFileProperties = sproutSecurityFileProperties;
	}

	public SproutSecurityDbProperties getSproutSecurityDbProperties() {
		return sproutSecurityDbProperties;
	}

	public void setSproutSecurityDbProperties(SproutSecurityDbProperties sproutSecurityDbProperties) {
		this.sproutSecurityDbProperties = sproutSecurityDbProperties;
	}

	@ConfigurationProperties(prefix = SproutAutoConfigConst.PREFIX_SPROUT_SECURITY_CORE)
	public static class SproutSecurityCoreProperties {
		
		/** 
		 * Sprout Security Core 설정파일경로 
		 */
		private String location;

		public String getLocation() {
			return location;
		}

		public void setLocation(String location) {
			this.location = location;
		}
		
	}
	
	@ConfigurationProperties(prefix = SproutAutoConfigConst.PREFIX_SPROUT_SECURITY_FILE)
	public static class SproutSecurityFileProperties {
		
		/** 
		 * Sprout Security File 설정파일경로 
		 */
		private String location;

		public String getLocation() {
			return location;
		}

		public void setLocation(String location) {
			this.location = location;
		}
	    	
	}
	
	@ConfigurationProperties(prefix = SproutAutoConfigConst.PREFIX_SPROUT_SECURITY_DB)
	public static class SproutSecurityDbProperties {
		
		/** 
		 * Sprout Security DB 사용여부 
		 */
    	private boolean enabled = false;
    	
    	/** 
    	 * Sprout Security DB 설정파일경로 
    	 */
    	private String location;

		public boolean isEnabled() {
			return enabled;
		}

		public void setEnabled(boolean enabled) {
			this.enabled = enabled;
		}

		public String getLocation() {
			return location;
		}

		public void setLocation(String location) {
			this.location = location;
		}
	    	
	}

}
