package nexcore.sprout.spring.boot.autoconfigure.security;

import javax.servlet.DispatcherType;

import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.embedded.FilterRegistrationBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.Ordered;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.session.SessionManagementFilter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@Configuration
@ConditionalOnClass({ EnableWebSecurity.class, AuthenticationEntryPoint.class })
@ConditionalOnProperty(prefix = SproutAutoConfigConst.PREFIX_SPROUT_SECURITY_DB, name = "enabled", havingValue="false", matchIfMissing=true)
@EnableWebSecurity
@EnableConfigurationProperties({SproutSecurityProperties.class})
public class SproutSecurityByFileAutoConfiguration extends WebMvcConfigurerAdapter {

	@Bean
	@ConditionalOnMissingBean
	public FilterRegistrationBean sessionManagementFilter() {
		FilterRegistrationBean registration = new FilterRegistrationBean();
		registration.setFilter(new SessionManagementFilter(new HttpSessionSecurityContextRepository()));
		registration.setOrder(Ordered.HIGHEST_PRECEDENCE);
		registration.setName("sessionManagementFilter");
		registration.setDispatcherTypes(DispatcherType.REQUEST);
		return registration;
	}	
	
	@Configuration
	@ConditionalOnProperty(prefix = SproutAutoConfigConst.PREFIX_SPROUT_SECURITY_FILE, name = "location")
	@ConditionalOnResource(resources="${sprout.security.core.location}")
	@ImportResource(locations = {"${sprout.security.file.location}", "${sprout.security.core.location}"})
	protected static class SproutSecurityAutoConfiguration {
		
	}
	
}