package nexcore.sprout.spring.boot.autoconfigure.resourcebundle;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import nexcore.sprout.foundry.resourcebundle.code.CodeSource;
import nexcore.sprout.foundry.resourcebundle.code.CodeSourceAccessor;
import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@Configuration
@ConditionalOnBean(CodeSource.class)
public class CodeSourceAccessorAutoConfiguration implements ApplicationContextAware {
	
	private static final Log logger = LogFactory.getLog(CodeSourceAccessorAutoConfiguration.class);
	
	@Autowired
	private ApplicationContext applicationContext;
	
	@Bean
	@ConditionalOnMissingBean(CodeSourceAccessor.class)
	public CodeSourceAccessor codeSourceAccessor(){
		try {
			CodeSource codeSource = this.applicationContext.getBean(SproutAutoConfigConst.CODE_SOURCE, CodeSource.class);
			CodeSourceAccessor codeSourceAccessor = new CodeSourceAccessor(codeSource);
			
			logger.info("====== Creating CodeSourceAccessor Bean: " + codeSourceAccessor.getClass().toString());
			logger.info("====== CodeSource for CodeSourceAccessor: " + codeSource.getClass().toString());
			return codeSourceAccessor;
		} catch (NullPointerException e) {
			logger.info("====== CodeSource is not exist.");
			logger.info("====== CodeSourceAccessor is not created.");			
			return null;
		}
	}
	
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		if (applicationContext instanceof ConfigurableApplicationContext) {
			this.applicationContext = (ConfigurableApplicationContext) applicationContext;
		}
	}
	
}
