package nexcore.sprout.spring.boot.autoconfigure.resourcebundle;

import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import nexcore.sprout.foundry.resourcebundle.code.DBReloadableResourceBundleCodeSource;
import nexcore.sprout.foundry.resourcebundle.code.ReloadableResourceBundleCodeSource;
import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;
import nexcore.sprout.spring.boot.autoconfigure.jdbc.SproutDataSourceAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.resourcebundle.CodeSourceProperties.CodeDataSourceProperties;

@Configuration
@EnableConfigurationProperties(CodeDataSourceProperties.class)
@AutoConfigureBefore(CodeSourceAutoConfiguration.class)
@AutoConfigureAfter(SproutDataSourceAutoConfiguration.class)
@ConditionalOnMissingBean(ReloadableResourceBundleCodeSource.class)
@ConditionalOnProperty(prefix = SproutAutoConfigConst.PREFIX_SPROUT_CODE_DATASOURCE, name = "enabled", havingValue = "true")
public class CodeDataSourceAutoConfiguration implements ApplicationContextAware {
	
	private static final Log logger = LogFactory.getLog(CodeDataSourceAutoConfiguration.class);
	
	@Autowired
	private ApplicationContext applicationContext;
	
	@Autowired
	private CodeDataSourceProperties codeDataSourceProperties;
	
	@Bean
	@ConditionalOnBean(name=SproutAutoConfigConst.DATASOURCE_FOR_SPROUT_NAME)
	public DBReloadableResourceBundleCodeSource codeSource() {
		logger.info("===== CodeSource DataSource Enabled: True");
		
		DBReloadableResourceBundleCodeSource codeDataSource = new DBReloadableResourceBundleCodeSource();
		codeDataSource.setDataSource((DataSource) this.applicationContext.getBean(SproutAutoConfigConst.DATASOURCE_FOR_SPROUT_NAME));
		
		if(codeDataSourceProperties.isFallbackToSystemLocale())
			codeDataSource.setFallbackToSystemLocale(codeDataSourceProperties.isFallbackToSystemLocale());
		if(codeDataSourceProperties.getName() != null)	
			codeDataSource.setBeanName(codeDataSourceProperties.getName());
		if(codeDataSourceProperties.getOrder() != Integer.MAX_VALUE)	
			codeDataSource.setOrder(codeDataSourceProperties.getOrder());
		if(codeDataSourceProperties.getCacheSeconds() != 0)
			codeDataSource.setCacheSeconds(codeDataSourceProperties.getCacheSeconds());
		if(codeDataSourceProperties.getQueryCode() != null)
			codeDataSource.setQueryCode(codeDataSourceProperties.getQueryCode());
		
		logger.info("====== Creating CodeSourceForDB.");
		return codeDataSource;
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.applicationContext = applicationContext;
	}

}
