package nexcore.sprout.spring.boot.autoconfigure.log;

import org.springframework.boot.context.properties.ConfigurationProperties;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@ConfigurationProperties(prefix = SproutAutoConfigConst.PREFIX_SPROUT_ACCESS_LOG)
public class AccessLogProperties {
	
	/** 
	 * 기본 Access Log 사용여부.
	 * Default Value: true
	 */
	private boolean enabled = true;
	
	/**
	 * Access Log를 DB에 Insert하기 위한 Query.
	 * Default Query::
	 * INSERT INTO NSF_TRAN_LOG
	 * 	(	LOG_DT, SEQ_NO,GLOB_ID,MENU_ID,IPAD,
	 * 		TRN_CD,USER_ID,GROUP_ID,OS_VER,AGENT_VER,
	 * 		SVC_STRN_DTTM,SVC_END_DTTM,RSLT_MSG,RSLT_MSG_CD,WAS_INSTANCE_ID,
	 * 		ELAPSE_TIME
	 * ) VALUES (
	 * 		:logDt,null,:globId,:menuId,:ipad,
	 * 		:trnCd,:userId,:groupId,:osVer,:agentVer,
	 * 		:svcStrnDttm,:svcEndDttm,:rsltMsg,:rsltMsgCd,:wasInstanceId,:elapseTime
	 * )
	 */
	private String insertQuery;
	
	/**
	 * Error Log를 DB에 기록할 지에 대한 여부 설정
	 */
	private boolean writeErrorLog;
	
	public boolean isEnabled() {
		return enabled;
	}
	public void setEnabled(boolean enabled) {
		this.enabled = enabled;
	}
	public String getInsertQuery() {
		return insertQuery;
	}
	public void setInsertQuery(String insertQuery) {
		this.insertQuery = insertQuery;
	}
	public boolean isWriteErrorLog() {
		return writeErrorLog;
	}
	public void setWriteErrorLog(boolean writeErrorLog) {
		this.writeErrorLog = writeErrorLog;
	}
	
	@ConfigurationProperties(prefix = SproutAutoConfigConst.PREFIX_SPROUT_ERROR_LOG)
	public static class ErrorLogProperties {
		
		/**
		 * Error Log를 DB에 Insert하기 위한 Query.
		 * Default Query::
		 * INSERT INTO NSF_ERROR_LOG 
		 * (	SEQ_NO, GLOB_ID,CREATEDTIMESTAMP,EXCEPTION_CLASS,WAS_INSTANCE_ID,
		 * 		REQUEST_URI,HTTP_METHOD,IP,CONTROLLER,METHOD,
		 * 		MENU_ID,USER_ID,OS_VER,AGENT_VER,ELAPSE_TIME,
		 * 		RSLT_MSG_CD,RSLT_MSG,EXCEPTION_MESSAGE,STACKTRACE
		 * ) VALUES (
		 * 		SEQ_NSF_TRAN_LOG_00.NEXTVAL,:GLOB_ID,:CREATEDTIMESTAMP,:EXCEPTION_CLASS,:WAS_INSTANCE_ID,
		 * 		:REQUEST_URI,:HTTP_METHOD,:IP,:CONTROLLER,:METHOD,
		 *		:MENU_ID,:USER_ID,:OS_VER,:AGENT_VER,:ELAPSE_TIME,
		 *		:RSLT_MSG_CD,:RSLT_MSG,:EXCEPTION_MESSAGE,:STACKTRACE
		 * )
		 */
		private String insertQuery;
		
		/** 
		 * 기본 Error Log 사용여부.
		 * Default Value: true
		 */
		private boolean enabled = true;
		
		public String getInsertQuery() {
			return insertQuery;
		}
		public void setInsertQuery(String insertQuery) {
			this.insertQuery = insertQuery;
		}
		public boolean isEnabled() {
			return enabled;
		}
		public void setEnabled(boolean enabled) {
			this.enabled = enabled;
		}
		
	}
	
}
