package nexcore.sprout.spring.boot.autoconfigure.log;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

import nexcore.sprout.foundry.log.accesslog.AccessLogManager;
import nexcore.sprout.foundry.log.accesslog.IAccessLogWriter;
import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@Configuration
@Profile(SproutAutoConfigConst.ACTIVE_PROFILE_NAME_TEST)
public class AccessLogManagerTestAutoConfiguration {
	
	@Bean
	@ConditionalOnMissingBean(AccessLogManager.class)
	@ConditionalOnBean(IAccessLogWriter.class)
	public AccessLogManager accessLogManager(){
		return new AccessLogManager();
	}
	
}
