package nexcore.sprout.spring.boot.autoconfigure.jmx;

import javax.management.MBeanServer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jmx.JmxAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.jmx.support.ConnectorServerFactoryBean;
import org.springframework.remoting.rmi.RmiRegistryFactoryBean;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@Configuration
@EnableConfigurationProperties(value = SproutJmxProperties.class)
@ConditionalOnBean({ MBeanServer.class })
@AutoConfigureAfter(JmxAutoConfiguration.class)
@ConditionalOnProperty(prefix = SproutAutoConfigConst.PREFIX_SPROUT_JMX, name = "enabled", havingValue="true")
public class SproutJmxAutoConfiguration {
	
	@Autowired
	private SproutJmxProperties jmxProperties;
	private static final Log logger = LogFactory.getLog(SproutJmxAutoConfiguration.class);
	
	@Bean
	@ConditionalOnMissingBean
	public RmiRegistryFactoryBean rmiRegistry() {
		RmiRegistryFactoryBean rmiRegistry = new RmiRegistryFactoryBean();
		rmiRegistry.setPort(jmxProperties.getRmiPort());
		logger.info("====== Creating Bean: " + this.getClass().toString());
		return rmiRegistry;
	}
	
	@Bean
	@DependsOn(value = "rmiRegistry")
	@ConditionalOnMissingBean
	public ConnectorServerFactoryBean serverConnector() {
		ConnectorServerFactoryBean serverConnector = new ConnectorServerFactoryBean();
		try {
			serverConnector.setObjectName(jmxProperties.getConnectorName());
			serverConnector.setServiceUrl(jmxProperties.getServiceUrl());
			serverConnector.setThreaded(jmxProperties.getThreaded());
		} catch (Exception e) {
			e.printStackTrace();
		}
		logger.info("====== Creating Bean: " + this.getClass().toString());
		return serverConnector;
	}
	
}
