package nexcore.sprout.spring.boot.autoconfigure.jdbc;
import javax.sql.DataSource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.AbstractTransactionManagementConfiguration;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@Configuration
@ConditionalOnClass({JdbcTemplate.class, PlatformTransactionManager.class })
@ConditionalOnBean(DataSource.class)
@AutoConfigureBefore(DataSourceTransactionManagerAutoConfiguration.class)
@ConditionalOnProperty(prefix=SproutAutoConfigConst.PREFIX_SPROUT_DATASOURCE,name="useConfig",matchIfMissing=true)
public class SproutTransactionManager implements ApplicationContextAware {
	
	private static final Log logger = LogFactory.getLog(SproutTransactionManager.class);
	
	@Autowired
	private ApplicationContext applicationContext;
	 
	@Bean
	@ConditionalOnMissingBean(name=SproutAutoConfigConst.TRANSACTION_MANAGER_NAME)
	public DataSourceTransactionManager transactionManager() {
		logger.info("====== Create " + SproutAutoConfigConst.TRANSACTION_MANAGER_NAME);
		return new DataSourceTransactionManager(this.applicationContext.getBean(SproutAutoConfigConst.DEFAULT_DATASOURCE_NAME, DataSource.class));
	}
	
	@Bean(name=SproutAutoConfigConst.TRANSACTION_MANAGER_FOR_SPROUT_NAME)
	@ConditionalOnBean(name=SproutAutoConfigConst.DATASOURCE_FOR_SPROUT_NAME)
	@ConditionalOnMissingBean(name=SproutAutoConfigConst.TRANSACTION_MANAGER_FOR_SPROUT_NAME)
	public DataSourceTransactionManager transactionManagerForSprout() {
		logger.info("====== Create " + SproutAutoConfigConst.TRANSACTION_MANAGER_FOR_SPROUT_NAME);
		return new DataSourceTransactionManager(this.applicationContext.getBean(SproutAutoConfigConst.DATASOURCE_FOR_SPROUT_NAME, DataSource.class));
	}

	@ConditionalOnMissingBean(AbstractTransactionManagementConfiguration.class)
	@Configuration
	@EnableTransactionManagement
	protected static class TransactionManagementConfiguration implements TransactionManagementConfigurer, ApplicationContextAware {
		
		@Autowired
		private ApplicationContext applicationContext;
		
		@Override
		public PlatformTransactionManager annotationDrivenTransactionManager() {
			logger.info("====== Set the " + SproutAutoConfigConst.TRANSACTION_MANAGER_NAME);
			return this.applicationContext.getBean(SproutAutoConfigConst.TRANSACTION_MANAGER_NAME, DataSourceTransactionManager.class) ;
		}
		@Override
		public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
			this.applicationContext = applicationContext;
		}
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.applicationContext = applicationContext;
	}
	
}