package nexcore.sprout.spring.boot.autoconfigure.jdbc;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

/**
 * spring.factories 에  ApplicationContextInitializer 로 등록됨 
 * # Initializers
 * org.springframework.context.ApplicationContextInitializer=nexcore.sprout.spring.boot.autoconfigure.jdbc.SproutJdbcApplicationContextInitializer
 * */
@EnableConfigurationProperties({ SproutDataSourceProperties.class })
public class SproutJdbcApplicationContextInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext> {
	
	// 해당 Bean 이름으로 BeanPostProcessor 를 등록할 경우 2개이상의 DataSource 사용시 DB 초기화 단계에서 오류가 발생함 
	@Override
	public void initialize(ConfigurableApplicationContext applicationContext) {
		BeanFactory c=applicationContext.getBeanFactory();
		BeanDefinitionRegistry registry=((BeanDefinitionRegistry)c) ;
		if (!registry.containsBeanDefinition(SproutAutoConfigConst.DATASOURCE_INITIALIZER_POST_PROCESSOR)) {
			GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
			beanDefinition.setBeanClass(SproutDataSourcePostProcessor.class);
			beanDefinition.setRole(BeanDefinition.ROLE_INFRASTRUCTURE);
			beanDefinition.setSynthetic(true);
			registry.registerBeanDefinition(SproutAutoConfigConst.DATASOURCE_INITIALIZER_POST_PROCESSOR, beanDefinition);
		}
	}
	
}
