package nexcore.sprout.spring.boot.autoconfigure.jdbc;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.core.Ordered;

import net.sf.log4jdbc.Log4jdbcProxyDataSource;

/**
 * sql log 처리를 위해 DataSource 생성 시 sproutSqlLogProperties.useSqlLog 를 기준으로
 * Log4jdbcProxyDataSource 를 반환함 </br>
 * SproutJdbcApplicationContextInitializer 에서 Bean 으로 등록함
 * 
 * @see Log4jdbcProxyDataSource
 * @see SproutJdbcApplicationContextInitializer
 */
@EnableConfigurationProperties({ SproutSqlLogProperties.class })
public class SproutDataSourcePostProcessor implements BeanPostProcessor, Ordered {
//	@Autowired
//	private SproutDataSourceInitializer sproutDataSourceInitializer;

	@Autowired
	private BeanFactory beanFactory;
	
	@Override
	public int getOrder() {
		return 0;
	}

	@Override
	public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
		if (beanName.equals("dataSourceInitializer") && bean.getClass().getName()
				.equals("org.springframework.boot.autoconfigure.jdbc.DataSourceInitializer")) {
			if (beanFactory.containsBean("sproutDataSourceInitializer")) {
				return beanFactory.getBean("sproutDataSourceInitializer");
			} 
		}
		return bean;
	}
	
	@Override
	public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
		return bean;
	}
	
//	@Override
//	public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
//		if (sproutDataSourceProperties.isUseConfig()) {
//			if (bean instanceof DataSource) {
//				if (bean instanceof Log4jdbcProxyDataSource) {
//					return bean;
//				}
//				if (beanName.equals(SproutDataSourceAutoConfiguration.dataSourceForSproutName)) {
//					return bean;
//				}
//				if (sproutSqlLogProperties.isUse()) {
//					Log4jdbcProxyDataSource dataSourceForSrpout = new Log4jdbcProxyDataSource((DataSource) bean);
//					SpyLogDelegator sl = beanFactory.getBean(SpyLogDelegator.class);
//					dataSourceForSrpout.setLogFormatter(sl);
//					return dataSourceForSrpout;
//				}
//			}
//		}
//		return bean;
//	}
}
