package nexcore.sprout.spring.boot.autoconfigure.exception;

import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerExceptionResolverComposite;

import nexcore.sprout.foundry.exception.hanlder.ExceptionHandler;
import nexcore.sprout.foundry.exception.hanlder.web.DefaultMvcExceptionResolver;
/**
 * 
 * @see WebMvcConfigurationSupport
 * @see HandlerExceptionResolverComposite
 * */
@Configuration
@ConditionalOnBean({ExceptionHandler.class})
@ConditionalOnMissingBean(DefaultMvcExceptionResolver.class)
public class SproutExceptionResolverAutoConfiguration extends WebMvcConfigurerAdapter  {
	
	private static final Log logger = LogFactory.getLog(SproutExceptionResolverAutoConfiguration.class);
	
	@Autowired
	private ApplicationContext applicationContext;
	
	@Bean
	@ConditionalOnMissingBean(DefaultMvcExceptionResolver.class)
	public DefaultMvcExceptionResolver exceptionResolver() throws IOException {
		DefaultMvcExceptionResolver exceptionResolver = new DefaultMvcExceptionResolver();
		exceptionResolver.setExceptionHandler(this.applicationContext.getBean(ExceptionHandler.class));
		exceptionResolver.setOrder(Ordered.LOWEST_PRECEDENCE);
		logger.info("====== Creating Bean: " + exceptionResolver.getClass().toString());
		logger.info("====== ExceptionHandler for ExceptionResolver: " + this.applicationContext.getBean(ExceptionHandler.class).toString());
		
		return exceptionResolver;
	}
}
