package nexcore.sprout.spring.boot.autoconfigure.exception;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.core.io.Resource;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@ConfigurationProperties(prefix = SproutAutoConfigConst.PREFIX_SPROUT_EXCEPTION)
public class SproutExceptionProperties {
	
	/** 
	 * Error Property 파일 위치 설정. 
	 * 
	 */
	private Resource location;
	
	/** 
	 * Error Property 파일을 찾지 못했을때 ignore 여부 설정.
	 * Default Value: false.
	 */
	private boolean ignoreResourceNotFound;
	
	/** 
	 * Error Property 파일을 로컬 property로 Override할지 여부 설정.
	 * Default Value: false
	 */
	private boolean localOverride;
	
	/** 
	 * Execption 발생시, 기본 View.
	 */
	private String defaultViewName;
	
	/** 
	 * 1.x BCM UI 지원 여부 설정.
	 * Default Value: false
	 */
	private boolean supportOldVersion;
	
	/** 
	 * StackTrace 출력여부
	 * Default Value: true
	 */
	private boolean printStackTrace;
	
	public Resource getLocation() {
		return location;
	}

	public void setLocation(Resource location) {
		this.location = location;
	}

	public boolean isIgnoreResourceNotFound() {
		return ignoreResourceNotFound;
	}

	public void setIgnoreResourceNotFound(boolean ignoreResourceNotFound) {
		this.ignoreResourceNotFound = ignoreResourceNotFound;
	}

	public boolean isLocalOverride() {
		return localOverride;
	}

	public void setLocalOverride(boolean localOverride) {
		this.localOverride = localOverride;
	}

	public String getDefaultViewName() {
		return defaultViewName;
	}

	public void setDefaultViewName(String defaultViewName) {
		this.defaultViewName = defaultViewName;
	}

	public boolean isSupportOldVersion() {
		return supportOldVersion;
	}

	public void setSupportOldVersion(boolean supportOldVersion) {
		this.supportOldVersion = supportOldVersion;
	}

	public boolean isPrintStackTrace() {
		return printStackTrace;
	}

	public void setPrintStackTrace(boolean printStackTrace) {
		this.printStackTrace = printStackTrace;
	}
	
}
