package nexcore.sprout.spring.boot.autoconfigure.exception;

import java.io.IOException;
import java.util.ArrayList;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import nexcore.sprout.foundry.exception.hanlder.ExceptionCodeResolver;
import nexcore.sprout.foundry.exception.hanlder.ExceptionHandler;
import nexcore.sprout.foundry.exception.hanlder.ExceptionTracer;
import nexcore.sprout.foundry.exception.hanlder.ExceptionTranslator;
import nexcore.sprout.foundry.exception.hanlder.impl.DefaultExceptionHandler;
import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@Configuration
@ConditionalOnBean({MessageSource.class, ExceptionCodeResolver.class, ExceptionTranslator.class, ExceptionTracer.class})
@ConditionalOnMissingBean(ExceptionHandler.class)
public class SproutExceptionHandlerAutoConfiguration implements ApplicationContextAware {
	
	private static final Log logger = LogFactory.getLog(SproutExceptionHandlerAutoConfiguration.class);
	
	@Autowired
	private ApplicationContext applicationContext;
	
	@Autowired
	private SproutExceptionCodeResolverConfiguration exceptionCodeResolverConfiguration;
	
	@Autowired
	private SproutExceptionTracerConfiguration exceptionTracerConfiguration;
	
	@Autowired
	private SproutExceptionTranslatorConfiguration exceptionTranslatorConfiguration;
	
	@Bean
	@ConditionalOnMissingBean
	public DefaultExceptionHandler exceptionHandler() throws IOException{
		DefaultExceptionHandler exceptionHandler = new DefaultExceptionHandler();

		// ExcetpionCodeResolver
		ArrayList<ExceptionCodeResolver> exceptionCodeResolverList = new ArrayList<ExceptionCodeResolver>();
		exceptionCodeResolverList.addAll(exceptionCodeResolverConfiguration.findExceptionCodeReoslvers());
		
		// ExceptionTranslator
		ArrayList<ExceptionTranslator> exceptionTranslatorList = new ArrayList<ExceptionTranslator>();
		exceptionTranslatorList.addAll(exceptionTranslatorConfiguration.findExceptionTranslator());

		// ExceptionTracer
		ArrayList<ExceptionTracer> exceptionTracerList = new ArrayList<ExceptionTracer>();
		exceptionTracerList.addAll(exceptionTracerConfiguration.findExceptionTracer());
		
		exceptionHandler.setMessageSource(this.applicationContext.getBean(SproutAutoConfigConst.MESSAGE_SOURCE, MessageSource.class));
		exceptionHandler.setExceptionCodeResolvers(exceptionCodeResolverList);
		exceptionHandler.setExceptionTranslators(exceptionTranslatorList);
		exceptionHandler.setExceptionTracers(exceptionTracerList);
		
		logger.info("====== Creating Bean: " + exceptionHandler.getClass().toString());
		return exceptionHandler;
	}

	@Override
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		this.applicationContext = applicationContext;
	}
	
}
