package nexcore.sprout.spring.boot.autoconfigure.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.WebMvcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import nexcore.sprout.foundry.event.SproutEventPublisher;
import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@Configuration
@ConditionalOnProperty(prefix = SproutAutoConfigConst.PREFIX_SPROUT_EVENT_PUBLISHER, name = "enabled", havingValue="true", matchIfMissing = true)
@EnableConfigurationProperties({ ResourceProperties.class,WebMvcProperties.class })
@AutoConfigureOrder(Ordered.LOWEST_PRECEDENCE)
public class EventAutoConfiguration extends WebMvcConfigurerAdapter{
	
	private static final Log logger = LogFactory.getLog(EventAutoConfiguration.class);
	
	@Autowired
	private ResourceProperties resourceProperties ;
	
	@Autowired
	private WebMvcProperties webMvcProperties ;
	
	@Bean
	@ConditionalOnMissingBean(SproutEventPublisher.class)
	public SproutEventPublisher sproutEventPublisher(){
		SproutEventPublisher sproutEventPublisher = new SproutEventPublisher();
		logger.info("====== Creating Bean: " + sproutEventPublisher.getClass().toString());
		return sproutEventPublisher;
	}
	
	@Override
	@ConditionalOnBean(SproutEventPublisher.class)
	public void addInterceptors(InterceptorRegistry registry) {		
		registry.addInterceptor(this.sproutEventPublisher())
				.addPathPatterns(webMvcProperties.getStaticPathPattern())
				.excludePathPatterns(resourceProperties.getStaticLocations());
		logger.info("====== Add Interceptor sproutEventPublisher");
	}
}
