package nexcore.sprout.spring.boot.autoconfigure.commons;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;

import nexcore.sprout.foundry.commons.IUserIdFinder;
import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@Configuration
@ConditionalOnMissingClass(SproutAutoConfigConst.SPRING_ENABLE_WEB_SECURITY_CLASS)
@AutoConfigureOrder(Ordered.LOWEST_PRECEDENCE)
public class UserIdFinderAutoConfiguration {
	
	private static final Log logger = LogFactory.getLog(UserIdFinderAutoConfiguration.class);

	/* Spring security 미사용시 사용한 UserId finder */
	@Bean(name=SproutAutoConfigConst.USER_ID_FINDER)
	@ConditionalOnMissingBean(IUserIdFinder.class)
	public IUserIdFinder userIdFinderForNotUsingSpringSecurity() {
		IUserIdFinder defaultUserIdFinder = new nexcore.sprout.foundry.commons.impl.UserIdFinderForNoSpringSecurity();
		logger.info("====== Creating UserIdFinder Bean: " + defaultUserIdFinder.getClass().toString());
		return defaultUserIdFinder;     
	}
}
