package nexcore.sprout.spring.boot.autoconfigure.commons;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import nexcore.sprout.foundry.commons.IGuidGenerator;
import nexcore.sprout.foundry.commons.impl.DefaultGuidGenerator;

@Configuration
public class GuidGeneratorAutoConfiguration {
	
	private static final Log logger = LogFactory.getLog(GuidGeneratorAutoConfiguration.class);
	
	@Bean
	@ConditionalOnMissingBean(IGuidGenerator.class)
	public DefaultGuidGenerator guidGenerator() {
		DefaultGuidGenerator defaultGuidGenerator = new DefaultGuidGenerator();
		logger.info("====== Creating Bean: " + defaultGuidGenerator.getClass().toString());
		return defaultGuidGenerator;
	}
}
