/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.tiles;

import java.util.ArrayList;
import java.util.Map;
import nexcore.sprout.spring.boot.autoconfigure.tiles.SproutTilesProperties;
import nexcore.sprout.spring.boot.autoconfigure.webmvc.SproutWebMvcAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.webmvc.SproutWebMvcProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.startup.TilesInitializer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.OrderComparator;
import org.springframework.util.StringUtils;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.ContentNegotiatingViewResolver;
import org.springframework.web.servlet.view.UrlBasedViewResolver;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.springframework.web.servlet.view.tiles3.SpringBeanPreparerFactory;
import org.springframework.web.servlet.view.tiles3.TilesConfigurer;
import org.springframework.web.servlet.view.tiles3.TilesView;

@Configuration
@ConditionalOnClass(value={TilesInitializer.class})
@AutoConfigureAfter(value={SproutWebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={SproutTilesProperties.class, SproutWebMvcProperties.class})
public class SproutTilesAutoConfiguration
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(SproutTilesAutoConfiguration.class);
    private ApplicationContext applicationContext;
    @Autowired
    private SproutWebMvcProperties sproutWebMvcProperties;
    @Autowired
    private SproutTilesProperties sproutTilesProperties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="sprout.tiles", value={"path"})
    public TilesConfigurer tilesConfigurer() {
        TilesConfigurer configurer = new TilesConfigurer();
        configurer.setDefinitions(StringUtils.commaDelimitedListToStringArray((String)StringUtils.trimAllWhitespace((String)this.sproutTilesProperties.getPath())));
        logger.info((Object)"====== Set the Tiles Configuration File Location.");
        if (SpringBeanPreparerFactory.class != null) {
            logger.info((Object)"====== Set the SpringBeanPreparerFactory ");
            configurer.setPreparerFactoryClass(SpringBeanPreparerFactory.class);
        }
        return configurer;
    }

    @Bean
    public UrlBasedViewResolver doView() {
        UrlBasedViewResolver doView = new UrlBasedViewResolver();
        doView.setViewClass(TilesView.class);
        doView.setPrefix(this.sproutWebMvcProperties.getDoPrefix());
        doView.setSuffix(this.sproutWebMvcProperties.getDoSuffix());
        doView.setOrder(Integer.MIN_VALUE);
        return doView;
    }

    @Bean(name={"fragView"})
    @ConditionalOnMissingBean(name={"fragView"})
    public UrlBasedViewResolver fragView() {
        UrlBasedViewResolver fragView = new UrlBasedViewResolver();
        fragView.setViewClass(TilesView.class);
        fragView.setPrefix(this.sproutWebMvcProperties.getFragPrefix());
        fragView.setSuffix(this.sproutWebMvcProperties.getFragSuffix());
        fragView.setContentType("application/plain");
        fragView.setOrder(-2147483638);
        return fragView;
    }

    @Bean(name={"viewResolver"})
    @ConditionalOnBean(value={ViewResolver.class})
    public ContentNegotiatingViewResolver viewResolver(BeanFactory beanFactory) {
        ContentNegotiatingViewResolver resolver = new ContentNegotiatingViewResolver();
        resolver.setContentNegotiationManager((ContentNegotiationManager)beanFactory.getBean(ContentNegotiationManager.class));
        Map viewResolvers = this.applicationContext.getBeansOfType(UrlBasedViewResolver.class);
        ArrayList viewResolverList = new ArrayList(viewResolvers.values());
        OrderComparator.sort(viewResolverList);
        resolver.setViewResolvers(viewResolverList);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"====== ViewResolver List in ContentNegotiatingViewResolver ======");
            for (ViewResolver viewResolver : viewResolverList) {
                logger.debug((Object)("ViewResolver: " + viewResolver.getClass()));
            }
            logger.debug((Object)"=================================================================");
        }
        ArrayList<MappingJackson2JsonView> defaultViewList = new ArrayList<MappingJackson2JsonView>();
        defaultViewList.add(new MappingJackson2JsonView());
        resolver.setDefaultViews(defaultViewList);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"====== DefaultView List in ContentNegotiatingViewResolver ======");
            for (View view : defaultViewList) {
                logger.debug((Object)("Default View: " + view.getClass()));
            }
            logger.debug((Object)"================================================================");
        }
        resolver.setOrder(Integer.MIN_VALUE);
        return resolver;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

