/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.session;

import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;
import nexcore.sprout.spring.boot.autoconfigure.redis.RedisAutoConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.session.Session;
import org.springframework.session.web.context.AbstractHttpSessionApplicationInitializer;

@Configuration
@ConditionalOnClass(value={Session.class})
@AutoConfigureAfter(value={RedisAutoConfiguration.class})
public class SessionAutoConfiguration
extends AbstractHttpSessionApplicationInitializer {
    private static final Log logger = LogFactory.getLog(SessionAutoConfiguration.class);
    @Autowired
    private Environment env;

    public void onStartup(ServletContext servletContext) throws ServletException {
        String[] profiles = this.env.getActiveProfiles();
        List<String> profileList = Arrays.asList(SproutAutoConfigConst.ACTIVE_PROFILE_NAME_LIST);
        for (String activeProfile : profiles) {
            logger.info((Object)("====== Active Profile: " + activeProfile));
            if (!profileList.contains(activeProfile)) continue;
            super.onStartup(servletContext);
        }
    }
}

