/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.resourcebundle;

import javax.sql.DataSource;
import nexcore.sprout.foundry.resourcebundle.message.DBReloadableResourceBundleMessageSource;
import nexcore.sprout.foundry.resourcebundle.message.ReloadableResourceBundleMessageSource;
import nexcore.sprout.spring.boot.autoconfigure.jdbc.SproutDataSourceAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.resourcebundle.MessageSourceAccessorAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.resourcebundle.MessageSourceProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={MessageSourceProperties.class})
@AutoConfigureBefore(value={MessageSourceAccessorAutoConfiguration.class})
@AutoConfigureAfter(value={SproutDataSourceAutoConfiguration.class})
@ConditionalOnProperty(prefix="sprout.message.resource", name={"basename"})
public class MessageSourceAutoConfiguration
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(MessageSourceAutoConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private MessageSourceProperties messageSourceProperties;

    @Bean
    public ReloadableResourceBundleMessageSource messageSource() {
        ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
        messageSource.setBasenames(StringUtils.commaDelimitedListToStringArray((String)StringUtils.trimAllWhitespace((String)this.messageSourceProperties.getBasename())));
        if (this.messageSourceProperties.getDefaultEncoding() != null) {
            messageSource.setDefaultEncoding(this.messageSourceProperties.getDefaultEncoding());
        }
        if (this.messageSourceProperties.getDefaultFilePostFix() != null) {
            messageSource.setDefaultFilePostFix(this.messageSourceProperties.getDefaultFilePostFix());
        }
        if (this.messageSourceProperties.isUseCustomDefaultFile()) {
            messageSource.setUseCustomDefaultFile(this.messageSourceProperties.isUseCustomDefaultFile());
        }
        if (this.messageSourceProperties.isUseAutoReloading()) {
            messageSource.setUseAutoReloading(this.messageSourceProperties.isUseAutoReloading());
        }
        if (this.messageSourceProperties.getName() != null) {
            messageSource.setBeanName(this.messageSourceProperties.getName());
        }
        try {
            DBReloadableResourceBundleMessageSource messageSourceForDb = (DBReloadableResourceBundleMessageSource)this.applicationContext.getBean(DBReloadableResourceBundleMessageSource.class);
            messageSource.setParentMessageSource((MessageSource)messageSourceForDb);
            logger.info((Object)"====== MessageSource For ParentMessageSource is created.");
        }
        catch (NoSuchBeanDefinitionException ex) {
            logger.info((Object)"====== MessageSource For ParentMessageSource is not created.");
        }
        logger.info((Object)("====== Creating ReloadableResourceBundleMessageSource Bean: " + messageSource.getClass().toString()));
        return messageSource;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Configuration
    @EnableConfigurationProperties(value={MessageSourceProperties.MessageDataSourceProperties.class})
    @AutoConfigureBefore(value={MessageSourceAutoConfiguration.class})
    @AutoConfigureAfter(value={SproutDataSourceAutoConfiguration.class})
    @ConditionalOnProperty(prefix="sprout.message.datasource", name={"enabled"}, havingValue="true")
    protected static class SproutMessageDataSourceAutoConfiguration
    implements ApplicationContextAware {
        private static final Log logger = LogFactory.getLog(SproutMessageDataSourceAutoConfiguration.class);
        @Autowired
        private ApplicationContext applicationContext;
        @Autowired
        private MessageSourceProperties.MessageDataSourceProperties messageDataSourceProperties;

        protected SproutMessageDataSourceAutoConfiguration() {
        }

        @Bean
        @ConditionalOnBean(name={"dataSourceForSprout"})
        public DBReloadableResourceBundleMessageSource messageSourceForDb() {
            logger.info((Object)"===== MessageSource DataSource Enabled: True");
            DBReloadableResourceBundleMessageSource messageDatasource = new DBReloadableResourceBundleMessageSource();
            messageDatasource.setDataSource((DataSource)this.applicationContext.getBean("dataSourceForSprout"));
            if (this.messageDataSourceProperties.isFallbackToSystemLocale()) {
                messageDatasource.setFallbackToSystemLocale(this.messageDataSourceProperties.isFallbackToSystemLocale());
            }
            if (this.messageDataSourceProperties.getCacheSeconds() != 0) {
                messageDatasource.setCacheSeconds(this.messageDataSourceProperties.getCacheSeconds());
            }
            if (this.messageDataSourceProperties.getQueryCode() != null) {
                messageDatasource.setQueryCode(this.messageDataSourceProperties.getQueryCode());
            }
            if (this.messageDataSourceProperties.getName() != null) {
                messageDatasource.setBeanName(this.messageDataSourceProperties.getName());
            }
            logger.info((Object)"====== Creating MessageSource For ParentMessageSource.");
            return messageDatasource;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }
    }
}

