/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.resourcebundle;

import javax.sql.DataSource;
import nexcore.sprout.foundry.resourcebundle.code.CodeSource;
import nexcore.sprout.foundry.resourcebundle.code.DBReloadableResourceBundleCodeSource;
import nexcore.sprout.foundry.resourcebundle.code.ReloadableResourceBundleCodeSource;
import nexcore.sprout.spring.boot.autoconfigure.jdbc.SproutDataSourceAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.resourcebundle.CodeSourceAccessorAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.resourcebundle.CodeSourceProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={CodeSourceProperties.class})
@AutoConfigureBefore(value={CodeSourceAccessorAutoConfiguration.class})
@AutoConfigureAfter(value={SproutDataSourceAutoConfiguration.class})
@ConditionalOnProperty(prefix="sprout.code.resource", name={"basename"})
public class CodeSourceAutoConfiguration
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(CodeSourceAutoConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CodeSourceProperties codeSourceProperties;

    @Bean
    public ReloadableResourceBundleCodeSource codeSource() {
        ReloadableResourceBundleCodeSource codeSource = new ReloadableResourceBundleCodeSource();
        codeSource.setBasenames(StringUtils.commaDelimitedListToStringArray((String)StringUtils.trimAllWhitespace((String)this.codeSourceProperties.getBasename())));
        if (this.codeSourceProperties.getDefaultEncoding() != null) {
            codeSource.setDefaultEncoding(this.codeSourceProperties.getDefaultEncoding());
        }
        if (this.codeSourceProperties.isFallbackToSystemLocale()) {
            codeSource.setFallbackToSystemLocale(this.codeSourceProperties.isFallbackToSystemLocale());
        }
        if (this.codeSourceProperties.getDefaultFilePostFix() != null) {
            codeSource.setDefaultFilePostFix(this.codeSourceProperties.getDefaultFilePostFix());
        }
        if (this.codeSourceProperties.getName() != null) {
            codeSource.setBeanName(this.codeSourceProperties.getName());
        }
        if (this.codeSourceProperties.getCacheSeconds() != 0) {
            codeSource.setCacheSeconds(this.codeSourceProperties.getCacheSeconds());
        }
        if (this.codeSourceProperties.getOrder() != Integer.MAX_VALUE) {
            codeSource.setOrder(this.codeSourceProperties.getOrder());
        }
        try {
            DBReloadableResourceBundleCodeSource codeSourceForDb = (DBReloadableResourceBundleCodeSource)this.applicationContext.getBean(DBReloadableResourceBundleCodeSource.class);
            codeSource.setParentCodeSource((CodeSource)codeSourceForDb);
            logger.info((Object)"====== CodeSource For ParentMessageSource is created.");
        }
        catch (NoSuchBeanDefinitionException ex) {
            logger.info((Object)"====== CodeSource For ParentMessageSource is not created.");
        }
        logger.info((Object)("====== Creating ReloadableResourceBundleCodeSource Bean: " + codeSource.getClass().toString()));
        return codeSource;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @Configuration
    @EnableConfigurationProperties(value={CodeSourceProperties.CodeDataSourceProperties.class})
    @AutoConfigureBefore(value={CodeSourceAutoConfiguration.class})
    @AutoConfigureAfter(value={SproutDataSourceAutoConfiguration.class})
    @ConditionalOnProperty(prefix="sprout.code.datasource", name={"enabled"}, havingValue="true")
    protected static class CodeDataSourceAutoConfiguration
    implements ApplicationContextAware {
        private static final Log logger = LogFactory.getLog(CodeDataSourceAutoConfiguration.class);
        @Autowired
        private ApplicationContext applicationContext;
        @Autowired
        private CodeSourceProperties.CodeDataSourceProperties codeDataSourceProperties;

        protected CodeDataSourceAutoConfiguration() {
        }

        @Bean
        @ConditionalOnBean(name={"dataSourceForSprout"})
        public DBReloadableResourceBundleCodeSource codeSourceForDb() {
            logger.info((Object)"===== CodeSource DataSource Enabled: True");
            DBReloadableResourceBundleCodeSource codeDataSource = new DBReloadableResourceBundleCodeSource();
            codeDataSource.setDataSource((DataSource)this.applicationContext.getBean("dataSourceForSprout"));
            if (this.codeDataSourceProperties.isFallbackToSystemLocale()) {
                codeDataSource.setFallbackToSystemLocale(this.codeDataSourceProperties.isFallbackToSystemLocale());
            }
            if (this.codeDataSourceProperties.getName() != null) {
                codeDataSource.setBeanName(this.codeDataSourceProperties.getName());
            }
            if (this.codeDataSourceProperties.getOrder() != Integer.MAX_VALUE) {
                codeDataSource.setOrder(this.codeDataSourceProperties.getOrder());
            }
            if (this.codeDataSourceProperties.getCacheSeconds() != 0) {
                codeDataSource.setCacheSeconds(this.codeDataSourceProperties.getCacheSeconds());
            }
            if (this.codeDataSourceProperties.getQueryCode() != null) {
                codeDataSource.setQueryCode(this.codeDataSourceProperties.getQueryCode());
            }
            logger.info((Object)"====== Creating CodeSource For ParentMessageSource.");
            return codeDataSource;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }
    }
}

