/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.reload;

import nexcore.sprout.foundry.reload.ReloadMulticaster;
import nexcore.sprout.foundry.utils.ProfileUtil;
import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.core.env.Environment;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;
import org.springframework.jmx.export.MBeanExporter;
import redis.clients.jedis.Jedis;

@Configuration
@ConditionalOnClass(value={MBeanExporter.class})
@ConditionalOnProperty(prefix="sprout.reload-multicaster", name={"enabled"}, havingValue="true")
public class ReloadAutoConfiguration {
    private static final Log logger = LogFactory.getLog(ReloadAutoConfiguration.class);

    @Bean
    public ReloadMulticaster reloadMulticaster() {
        ReloadMulticaster reloadMulticaster = new ReloadMulticaster();
        logger.info((Object)("====== Creating Bean: " + reloadMulticaster.getClass().toString()));
        return reloadMulticaster;
    }

    @Configuration
    @ConditionalOnClass(value={JedisConnection.class, RedisOperations.class, Jedis.class})
    @Profile(value={"dev"})
    @AutoConfigureAfter(value={ReloadMulticaster.class})
    protected static class ReloadForRedis {
        private static final Log logger = LogFactory.getLog(ReloadForRedis.class);
        @Autowired
        private Environment env;

        protected ReloadForRedis() {
        }

        @Bean
        public RedisMessageListenerContainer container(RedisConnectionFactory connectionFactory, MessageListenerAdapter listenerAdapter) {
            RedisMessageListenerContainer container = new RedisMessageListenerContainer();
            container.setConnectionFactory(connectionFactory);
            container.addMessageListener((MessageListener)listenerAdapter, (Topic)this.topic());
            logger.info((Object)("====== Creating Bean: " + container.getClass().toString()));
            return container;
        }

        @Bean
        public MessageListenerAdapter listenerAdapter(ReloadMulticaster receiver) {
            MessageListenerAdapter listenerAdapter = new MessageListenerAdapter();
            listenerAdapter.setDelegate((Object)receiver);
            listenerAdapter.setDefaultListenerMethod("multicastReloadingEvent");
            logger.info((Object)("====== Creating Bean: " + listenerAdapter.getClass().toString()));
            return listenerAdapter;
        }

        @Bean
        public ChannelTopic topic() {
            String activeProfile = ProfileUtil.getActiveProfile((Environment)this.env, (String[])SproutAutoConfigConst.ACTIVE_PROFILE_NAME_LIST);
            String topic = "reload." + activeProfile;
            logger.info((Object)("====== Redis Topic : " + topic));
            return new ChannelTopic(topic);
        }
    }
}

