/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.log.monitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nexcore.sprout.log.monitor.PeriodLogTimer;
import nexcore.sprout.log.monitor.SproutHttpSessionCountListener;
import nexcore.sprout.log.monitor.gatherer.IPeriodicalLogGatherer;
import nexcore.sprout.log.monitor.gatherer.SessionCountGatherer;
import nexcore.sprout.log.monitor.gatherer.SystemDataGatherer;
import nexcore.sprout.log.monitor.processor.ILogDataProcessor;
import nexcore.sprout.log.monitor.processor.SystemStatusLogDataProcessor;
import nexcore.sprout.log.monitor.writer.logstash.PeriodLogstashLogWriter;
import nexcore.sprout.spring.boot.autoconfigure.log.monitor.LogMonitorProperties;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;

@Configuration
@EnableConfigurationProperties(value={LogMonitorProperties.class})
@ConditionalOnProperty(prefix="sprout.log.monitor", name={"enabled"}, havingValue="true")
public class PeriodLogWriterConfiguration {
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private LogMonitorProperties logMonitorProperties;

    @Bean
    public PeriodLogTimer periodLogTimer() {
        PeriodLogTimer periodLogTimer = new PeriodLogTimer(this.logMonitorProperties.getWriteLogInterval(), this.periodLogstashLogWriter());
        periodLogTimer.setUseYN(true);
        return periodLogTimer;
    }

    @Bean
    public PeriodLogstashLogWriter periodLogstashLogWriter() {
        PeriodLogstashLogWriter periodLogstashLogWriter = new PeriodLogstashLogWriter();
        periodLogstashLogWriter.setLogDataProcessors(this.findILogDataProcessor());
        periodLogstashLogWriter.setLogstashLoggerName(this.logMonitorProperties.getPeriodLoggerName());
        return periodLogstashLogWriter;
    }

    @Bean
    @ConditionalOnMissingBean(name={"systemDataGatherer"})
    public IPeriodicalLogGatherer systemDataGatherer() {
        return new SystemDataGatherer();
    }

    @Bean
    @ConditionalOnMissingBean(name={"sessionCountGatherer"})
    public IPeriodicalLogGatherer sessionCountGatherer() {
        SessionCountGatherer sessionCountGatherer = new SessionCountGatherer();
        sessionCountGatherer.setListener(this.sessionListener());
        return sessionCountGatherer;
    }

    @Bean
    @ConditionalOnMissingBean(name={"systemStatusLogDataProcessor"})
    public ILogDataProcessor systemStatusLogDataProcessor() {
        SystemStatusLogDataProcessor systemStatusLogDataProcessor = new SystemStatusLogDataProcessor();
        systemStatusLogDataProcessor.setLogGatherers(this.findILogGatherer());
        systemStatusLogDataProcessor.setServiceGroupName(this.logMonitorProperties.getPeriodLoggerName());
        return systemStatusLogDataProcessor;
    }

    private <T> Collection<T> getBeans(Class<T> type) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext.getBeanFactory(), type).values();
    }

    @Bean
    @ConditionalOnMissingBean(name={"sessionListener"})
    public SproutHttpSessionCountListener sessionListener() {
        return new SproutHttpSessionCountListener();
    }

    public List<IPeriodicalLogGatherer> findILogGatherer() {
        ArrayList<IPeriodicalLogGatherer> iLogGathererList = new ArrayList<IPeriodicalLogGatherer>();
        if (this.applicationContext == null) {
            return Collections.emptyList();
        }
        for (IPeriodicalLogGatherer iLogGatherer : this.getBeans(IPeriodicalLogGatherer.class)) {
            iLogGathererList.add(iLogGatherer);
        }
        return iLogGathererList;
    }

    public List<ILogDataProcessor> findILogDataProcessor() {
        ArrayList<ILogDataProcessor> iLogDataProcessorList = new ArrayList<ILogDataProcessor>();
        if (this.applicationContext == null) {
            return Collections.emptyList();
        }
        for (ILogDataProcessor iLogDataProcessor : this.getBeans(ILogDataProcessor.class)) {
            iLogDataProcessorList.add(iLogDataProcessor);
        }
        return iLogDataProcessorList;
    }

    @EventListener
    @Order(value=0x7FFFFFFF)
    public void onClosedContext(ContextClosedEvent event) {
        this.periodLogTimer().stopTimer();
    }
}

