/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.jdbc;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.AbstractTransactionManagementConfiguration;
import org.springframework.transaction.annotation.EnableTransactionManagement;
import org.springframework.transaction.annotation.TransactionManagementConfigurer;

@Configuration
@ConditionalOnClass(value={JdbcTemplate.class, PlatformTransactionManager.class})
@AutoConfigureBefore(value={DataSourceTransactionManagerAutoConfiguration.class})
@ConditionalOnProperty(prefix="sprout.datasource", name={"useConfig"}, matchIfMissing=true)
public class SproutTransactionManager
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(SproutTransactionManager.class);
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(name={"transactionManager"})
    public DataSourceTransactionManager transactionManager() {
        logger.info((Object)"====== Create transactionManager");
        return new DataSourceTransactionManager((DataSource)this.applicationContext.getBean("dataSource", DataSource.class));
    }

    @Bean(name={"transactionManagerForSprout"})
    @ConditionalOnBean(name={"dataSourceForSprout"})
    @ConditionalOnMissingBean(name={"transactionManagerForSprout"})
    public DataSourceTransactionManager transactionManagerForSprout() {
        logger.info((Object)"====== Create transactionManagerForSprout");
        return new DataSourceTransactionManager((DataSource)this.applicationContext.getBean("dataSourceForSprout", DataSource.class));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @ConditionalOnMissingBean(value={AbstractTransactionManagementConfiguration.class})
    @Configuration
    @EnableTransactionManagement
    protected static class TransactionManagementConfiguration
    implements TransactionManagementConfigurer,
    ApplicationContextAware {
        @Autowired
        private ApplicationContext applicationContext;

        protected TransactionManagementConfiguration() {
        }

        public PlatformTransactionManager annotationDrivenTransactionManager() {
            logger.info((Object)"====== Set the transactionManager");
            return (PlatformTransactionManager)this.applicationContext.getBean("transactionManager", DataSourceTransactionManager.class);
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }
    }
}

