/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.jdbc;

import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.boot.autoconfigure.MybatisAutoConfiguration;
import org.mybatis.spring.boot.autoconfigure.MybatisProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class, MybatisAutoConfiguration.class})
@EnableConfigurationProperties(value={MybatisProperties.class})
@AutoConfigureBefore(value={MybatisAutoConfiguration.class})
@ConditionalOnProperty(prefix="sprout.datasource", name={"useConfig"}, matchIfMissing=true)
public class SproutMybatisAutoConfiguration
extends MybatisAutoConfiguration {
    private static Log logger = LogFactory.getLog(SproutMybatisAutoConfiguration.class);
    private static final String mybatisConfigPath = "classpath:META-INF/persistence/mybatis/mybatis-config.xml";
    @Autowired
    private MybatisProperties properties;
    @Autowired
    private ResourceLoader resourceLoader = new DefaultResourceLoader();

    @Bean
    @ConditionalOnMissingBean
    public SqlSessionFactory sqlSessionFactory(DataSource dataSource) throws Exception {
        logger.debug((Object)"**************** Start create sqlSessionFactory");
        SqlSessionFactoryBean factory = new SqlSessionFactoryBean();
        factory.setDataSource(dataSource);
        if (StringUtils.hasText((String)this.properties.getConfig())) {
            factory.setConfigLocation(this.resourceLoader.getResource(this.properties.getConfig()));
        } else {
            logger.info((Object)"**************** mybatis.resource is null");
            if (ResourceUtils.getFile((String)mybatisConfigPath) != null) {
                logger.info((Object)"**************** MyBatis Configfile exist in classpath:META-INF/persistence/mybatis/mybatis-config.xml");
                Resource resource = new PathMatchingResourcePatternResolver().getResource(mybatisConfigPath);
                factory.setConfigLocation(resource);
            } else {
                factory.setTypeAliasesPackage(this.properties.getTypeAliasesPackage());
                factory.setTypeHandlersPackage(this.properties.getTypeHandlersPackage());
                factory.setMapperLocations(this.properties.getMapperLocations());
            }
        }
        return factory.getObject();
    }

    @Bean(destroyMethod="clearCache")
    @ConditionalOnMissingBean
    public SqlSessionTemplate sqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory, this.properties.getExecutorType());
    }
}

