/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.jdbc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceInitializedEvent;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.util.StringUtils;

public class SproutDataSourceInitializer
implements ApplicationListener<DataSourceInitializedEvent> {
    private static final Log logger = LogFactory.getLog(SproutDataSourceInitializer.class);
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    private DataSource dataSource;
    @Autowired
    private DataSourceProperties properties;
    private static boolean initialized = false;

    @PostConstruct
    public void init() {
        if (initialized) {
            return;
        }
        if (!this.properties.isInitialize()) {
            logger.debug((Object)"Initialization disabled (not running DDL scripts)");
            return;
        }
        if (this.applicationContext.getBean("dataSourceForSprout") != null) {
            this.dataSource = (DataSource)this.applicationContext.getBean("dataSourceForSprout");
        }
        if (this.dataSource == null) {
            logger.debug((Object)"No DataSource found so not initializing");
            return;
        }
        this.runSchemaScripts();
    }

    private void runSchemaScripts() {
        List<Resource> scripts = this.getScripts(this.properties.getSchema(), "schema");
        if (!scripts.isEmpty()) {
            this.runScripts(scripts);
            try {
                if (!initialized) {
                    this.runDataScripts();
                    initialized = true;
                }
            }
            catch (IllegalStateException ex) {
                logger.warn((Object)("Could not send event to complete DataSource initialization (" + ex.getMessage() + ")"));
            }
        }
    }

    public void onApplicationEvent(DataSourceInitializedEvent event) {
        if (!this.properties.isInitialize()) {
            logger.debug((Object)"Initialization disabled (not running data scripts)");
            return;
        }
        if (!initialized) {
            this.runDataScripts();
            initialized = true;
        }
    }

    private void runDataScripts() {
        List<Resource> scripts = this.getScripts(this.properties.getData(), "data");
        this.runScripts(scripts);
    }

    private List<Resource> getScripts(String locations, String fallback) {
        if (locations == null) {
            String platform = this.properties.getPlatform();
            locations = "classpath*:" + fallback + "-" + platform + ".sql,";
            locations = locations + "classpath*:" + fallback + ".sql";
        }
        return this.getResources(locations);
    }

    private List<Resource> getResources(String locations) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (String location : StringUtils.commaDelimitedListToStringArray((String)locations)) {
            try {
                for (Resource resource : this.applicationContext.getResources(location)) {
                    if (!resource.exists()) continue;
                    resources.add(resource);
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Unable to load resource from " + location, ex);
            }
        }
        return resources;
    }

    private void runScripts(List<Resource> resources) {
        if (resources.isEmpty()) {
            return;
        }
        ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
        populator.setContinueOnError(this.properties.isContinueOnError());
        populator.setSeparator(this.properties.getSeparator());
        if (this.properties.getSqlScriptEncoding() != null) {
            populator.setSqlScriptEncoding(this.properties.getSqlScriptEncoding().name());
        }
        for (Resource resource : resources) {
            populator.addScript(resource);
        }
        logger.info((Object)("Run Init Script : " + populator.toString()));
        DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)this.dataSource);
    }

    public ConfigurableApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ConfigurableApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSourceProperties getProperties() {
        return this.properties;
    }

    public void setProperties(DataSourceProperties properties) {
        this.properties = properties;
    }
}

