/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.jdbc;

import javax.sql.DataSource;
import javax.sql.XADataSource;
import net.sf.log4jdbc.Log4jdbcProxyDataSource;
import net.sf.log4jdbc.SpyLogDelegator;
import nexcore.sprout.foundry.log.sqllog.Log4JdbcCustomFormatter;
import nexcore.sprout.spring.boot.autoconfigure.jdbc.SproutDataSourceInitializer;
import nexcore.sprout.spring.boot.autoconfigure.jdbc.SproutDataSourceProperties;
import nexcore.sprout.spring.boot.autoconfigure.jdbc.SproutSqlLogProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.jdbc.datasource.embedded.EmbeddedDatabaseType;
import org.springframework.jdbc.datasource.lookup.JndiDataSourceLookup;
import org.springframework.jmx.export.MBeanExporter;
import org.springframework.jmx.support.JmxUtils;

@Configuration
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@ConditionalOnClass(value={DataSource.class, EmbeddedDatabaseType.class})
@EnableConfigurationProperties(value={DataSourceProperties.class, SproutDataSourceProperties.class, SproutSqlLogProperties.class})
@ConditionalOnProperty(prefix="sprout.datasource", name={"useConfig"}, matchIfMissing=true)
public class SproutDataSourceAutoConfiguration {
    private static final Log logger = LogFactory.getLog(SproutDataSourceAutoConfiguration.class);
    @Autowired
    private DataSourceProperties properties;
    @Autowired
    private SproutDataSourceProperties sproutDataSourceProperties;
    @Autowired
    private SproutSqlLogProperties sproutSqlLogProperties;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private BeanFactory beanFactory;

    @Bean(name={"dataSource"})
    @ConditionalOnMissingBean(value={DataSource.class, XADataSource.class})
    @ConditionalOnProperty(prefix="spring.datasource", name={"jndi-name"})
    @AutoConfigureOrder(value=-2147483648)
    public DataSource jndiDataSource() {
        return this.wrappingLog4jdbcDataSource(this.createJndiDataSource());
    }

    @Bean(name={"dataSource"})
    @ConditionalOnMissingBean(value={DataSource.class, XADataSource.class})
    @ConfigurationProperties(prefix="spring.datasource")
    @AutoConfigureOrder(value=-2147483647)
    public DataSource dataSource() {
        return this.wrappingLog4jdbcDataSource(SproutDataSourceAutoConfiguration.createDataSource(this.properties));
    }

    @ConditionalOnMissingBean(name={"dataSourceForSprout"})
    @ConditionalOnProperty(prefix="spring.datasource", name={"jndi-name"})
    @Bean(name={"dataSourceForSprout"})
    @AutoConfigureOrder(value=-2147483646)
    public Object dataSourceForSproutJndi() {
        logger.info((Object)"create datasourceForSprout");
        return this.createJndiDataSource();
    }

    @ConditionalOnMissingBean(name={"dataSourceForSprout"})
    @Bean(name={"dataSourceForSprout"})
    @AutoConfigureOrder(value=-2147483645)
    public Object dataSourceForSprout(DataSource dataSource) {
        logger.info((Object)"create datasourceForSprout");
        return SproutDataSourceAutoConfiguration.createDataSource(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    public Log4JdbcCustomFormatter sqlFormatter() {
        Log4JdbcCustomFormatter sqlFormatter = new Log4JdbcCustomFormatter();
        sqlFormatter.setSqlPrefix(this.sproutSqlLogProperties.getSqlLogPrefix());
        sqlFormatter.setLoggingCallMethod(this.sproutSqlLogProperties.isShowCallClass());
        sqlFormatter.setLineLength(this.sproutSqlLogProperties.getLineLength());
        return sqlFormatter;
    }

    private static DataSource createDataSource(DataSourceProperties properties) {
        DataSourceBuilder factory = DataSourceBuilder.create((ClassLoader)properties.getClassLoader()).driverClassName(properties.getDriverClassName()).url(properties.getUrl()).username(properties.getUsername()).password(properties.getPassword());
        if (properties.getType() != null) {
            factory.type(properties.getType());
        }
        return factory.build();
    }

    private DataSource createJndiDataSource() {
        JndiDataSourceLookup dataSourceLookup = new JndiDataSourceLookup();
        DataSource dataSource = dataSourceLookup.getDataSource(this.properties.getJndiName());
        this.excludeMBeanIfNecessary(dataSource, "dataSource");
        return dataSource;
    }

    private void excludeMBeanIfNecessary(Object candidate, String beanName) {
        try {
            MBeanExporter mbeanExporter = (MBeanExporter)this.context.getBean(MBeanExporter.class);
            if (JmxUtils.isMBean(candidate.getClass())) {
                mbeanExporter.addExcludedBean(beanName);
            }
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
    }

    private DataSource wrappingLog4jdbcDataSource(DataSource dataSource) {
        if (this.sproutSqlLogProperties.isUse()) {
            Log4jdbcProxyDataSource dataSourceForSrpout = new Log4jdbcProxyDataSource(dataSource);
            SpyLogDelegator sl = (SpyLogDelegator)this.beanFactory.getBean(SpyLogDelegator.class);
            dataSourceForSrpout.setLogFormatter(sl);
            return dataSourceForSrpout;
        }
        return dataSource;
    }

    @Bean
    @ConditionalOnMissingClass
    public SproutDataSourceInitializer sproutDataSourceInitializer() {
        return new SproutDataSourceInitializer();
    }

    @Configuration
    @Profile(value={"test"})
    protected static class SproutDataSourceTestAutoConfiguration {
        @Autowired
        private DataSourceProperties properties;

        protected SproutDataSourceTestAutoConfiguration() {
        }

        @Bean(name={"dataSource"})
        @ConditionalOnMissingBean(value={DataSource.class, XADataSource.class})
        @ConfigurationProperties(prefix="spring.datasource")
        public DataSource dataSource() {
            return SproutDataSourceAutoConfiguration.createDataSource(this.properties);
        }

        @ConditionalOnMissingBean(name={"dataSourceForSprout"})
        @Bean(name={"dataSourceForSprout"})
        public Object dataSourceForSprout(DataSource dataSource) {
            return SproutDataSourceAutoConfiguration.createDataSource(this.properties);
        }
    }
}

