/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.exception;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nexcore.sprout.foundry.exception.hanlder.ExceptionTracer;
import nexcore.sprout.foundry.exception.hanlder.impl.DefaultExceptionLogTracer;
import nexcore.sprout.spring.boot.autoconfigure.exception.SproutExceptionHandlerAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.exception.SproutExceptionProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SproutExceptionProperties.class})
@AutoConfigureBefore(value={SproutExceptionHandlerAutoConfiguration.class})
public class SproutExceptionTracerConfiguration
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(SproutExceptionTracerConfiguration.class);
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private SproutExceptionProperties exceptionProperties;

    @Bean
    @ConditionalOnMissingBean
    public DefaultExceptionLogTracer defaultExceptionLogTracer() {
        DefaultExceptionLogTracer defaultExceptionLogTracer = new DefaultExceptionLogTracer();
        if (this.exceptionProperties.isPrintStackTrace()) {
            defaultExceptionLogTracer.setPrintStackTrace(this.exceptionProperties.isPrintStackTrace());
        }
        logger.info((Object)("====== Creating Bean: " + defaultExceptionLogTracer.getClass().toString()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"====== Properties for Created Bean");
            logger.debug((Object)("====== PrintStackTrace: " + this.exceptionProperties.isPrintStackTrace()));
        }
        return defaultExceptionLogTracer;
    }

    public List<ExceptionTracer> findExceptionTracer() {
        ArrayList<ExceptionTracer> exceptionTracerList = new ArrayList<ExceptionTracer>();
        if (this.applicationContext == null) {
            logger.info((Object)"ExceptionLogTracer List is null.");
            return Collections.emptyList();
        }
        exceptionTracerList.addAll(this.getBeans(ExceptionTracer.class));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("====== Find Total ExceptionTracer: " + exceptionTracerList.size()));
            for (ExceptionTracer exceptionTracer : exceptionTracerList) {
                logger.debug((Object)("====== Find ExceptionTracer: " + exceptionTracer.getClass().toString()));
            }
        }
        return exceptionTracerList;
    }

    private <T> Collection<T> getBeans(Class<T> type) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext.getBeanFactory(), type).values();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }
}

