/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.exception;

import java.io.IOException;
import nexcore.sprout.foundry.exception.hanlder.ExceptionHandler;
import nexcore.sprout.foundry.exception.hanlder.web.DefaultMvcExceptionResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnBean(value={ExceptionHandler.class})
@ConditionalOnMissingBean(value={DefaultMvcExceptionResolver.class})
public class SproutExceptionResolverAutoConfiguration
extends WebMvcConfigurerAdapter {
    private static final Log logger = LogFactory.getLog(SproutExceptionResolverAutoConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean(value={DefaultMvcExceptionResolver.class})
    public DefaultMvcExceptionResolver exceptionResolver() throws IOException {
        DefaultMvcExceptionResolver exceptionResolver = new DefaultMvcExceptionResolver();
        exceptionResolver.setExceptionHandler((ExceptionHandler)this.applicationContext.getBean(ExceptionHandler.class));
        exceptionResolver.setOrder(Integer.MAX_VALUE);
        logger.info((Object)("====== Creating Bean: " + exceptionResolver.getClass().toString()));
        logger.info((Object)("====== ExceptionHandler for ExceptionResolver: " + ((ExceptionHandler)this.applicationContext.getBean(ExceptionHandler.class)).toString()));
        return exceptionResolver;
    }
}

