/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.exception;

import java.io.IOException;
import java.util.ArrayList;
import nexcore.sprout.foundry.exception.hanlder.ExceptionCodeResolver;
import nexcore.sprout.foundry.exception.hanlder.ExceptionHandler;
import nexcore.sprout.foundry.exception.hanlder.ExceptionTracer;
import nexcore.sprout.foundry.exception.hanlder.ExceptionTranslator;
import nexcore.sprout.foundry.exception.hanlder.impl.DefaultExceptionHandler;
import nexcore.sprout.spring.boot.autoconfigure.exception.SproutExceptionCodeResolverConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.exception.SproutExceptionTracerConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.exception.SproutExceptionTranslatorConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={MessageSource.class, ExceptionCodeResolver.class, ExceptionTranslator.class, ExceptionTracer.class})
@ConditionalOnMissingBean(value={ExceptionHandler.class})
public class SproutExceptionHandlerAutoConfiguration
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(SproutExceptionHandlerAutoConfiguration.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private SproutExceptionCodeResolverConfiguration exceptionCodeResolverConfiguration;
    @Autowired
    private SproutExceptionTracerConfiguration exceptionTracerConfiguration;
    @Autowired
    private SproutExceptionTranslatorConfiguration exceptionTranslatorConfiguration;

    @Bean
    @ConditionalOnMissingBean
    public DefaultExceptionHandler exceptionHandler() throws IOException {
        DefaultExceptionHandler exceptionHandler = new DefaultExceptionHandler();
        ArrayList<ExceptionCodeResolver> exceptionCodeResolverList = new ArrayList<ExceptionCodeResolver>();
        exceptionCodeResolverList.addAll(this.exceptionCodeResolverConfiguration.findExceptionCodeReoslvers());
        ArrayList<ExceptionTranslator> exceptionTranslatorList = new ArrayList<ExceptionTranslator>();
        exceptionTranslatorList.addAll(this.exceptionTranslatorConfiguration.findExceptionTranslator());
        ArrayList<ExceptionTracer> exceptionTracerList = new ArrayList<ExceptionTracer>();
        exceptionTracerList.addAll(this.exceptionTracerConfiguration.findExceptionTracer());
        exceptionHandler.setMessageSource((MessageSource)this.applicationContext.getBean("messageSource", MessageSource.class));
        exceptionHandler.setExceptionCodeResolvers(exceptionCodeResolverList);
        exceptionHandler.setExceptionTranslators(exceptionTranslatorList);
        exceptionHandler.setExceptionTracers(exceptionTracerList);
        logger.info((Object)("====== Creating Bean: " + exceptionHandler.getClass().toString()));
        return exceptionHandler;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

