/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.exception;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nexcore.sprout.foundry.exception.hanlder.ExceptionCodeResolver;
import nexcore.sprout.foundry.exception.hanlder.impl.DefaultExceptionCodeResolver;
import nexcore.sprout.foundry.exception.hanlder.impl.PropertyExceptionCodeResolver;
import nexcore.sprout.spring.boot.autoconfigure.exception.SproutExceptionHandlerAutoConfiguration;
import nexcore.sprout.spring.boot.autoconfigure.exception.SproutExceptionProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SproutExceptionProperties.class})
@AutoConfigureBefore(value={SproutExceptionHandlerAutoConfiguration.class})
public class SproutExceptionCodeResolverConfiguration
implements ApplicationContextAware {
    private static final Log logger = LogFactory.getLog(SproutExceptionCodeResolverConfiguration.class);
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    private SproutExceptionProperties exceptionProperties;

    @Bean
    @ConditionalOnMissingBean
    public DefaultExceptionCodeResolver defaultExceptionCodeResolver() {
        DefaultExceptionCodeResolver defaultExceptionCodeResolver = new DefaultExceptionCodeResolver();
        logger.info((Object)("====== Creating Bean: " + defaultExceptionCodeResolver.getClass().toString()));
        return defaultExceptionCodeResolver;
    }

    @Bean
    @ConditionalOnProperty(prefix="sprout.exception", name={"location"})
    public PropertyExceptionCodeResolver propertyExceptionResolver() throws IOException {
        PropertiesFactoryBean errorProperties = new PropertiesFactoryBean();
        errorProperties.setLocation(this.exceptionProperties.getLocation());
        if (this.exceptionProperties.isIgnoreResourceNotFound()) {
            errorProperties.setIgnoreResourceNotFound(this.exceptionProperties.isIgnoreResourceNotFound());
        }
        if (this.exceptionProperties.isLocalOverride()) {
            errorProperties.setLocalOverride(this.exceptionProperties.isLocalOverride());
        }
        logger.info((Object)("====== Creating Property Bean: " + errorProperties.getClass().toString()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"====== Properties for Created Bean");
            logger.debug((Object)("====== IgnoreResourceNotFounde: " + this.exceptionProperties.isIgnoreResourceNotFound()));
            logger.debug((Object)("====== LocalOverride: " + this.exceptionProperties.isLocalOverride()));
            logger.debug((Object)("====== Location: " + this.exceptionProperties.getLocation()));
        }
        PropertyExceptionCodeResolver propertyExceptionCodeResolver = new PropertyExceptionCodeResolver();
        propertyExceptionCodeResolver.setProperties(errorProperties.getObject());
        return propertyExceptionCodeResolver;
    }

    public List<ExceptionCodeResolver> findExceptionCodeReoslvers() {
        ArrayList<ExceptionCodeResolver> exceptionCodeResolverList = new ArrayList<ExceptionCodeResolver>();
        if (this.applicationContext == null) {
            logger.info((Object)"ExceptionCodeResolver List is null.");
            return Collections.emptyList();
        }
        exceptionCodeResolverList.addAll(this.getBeans(ExceptionCodeResolver.class));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("====== Find Total ExceptionCodeResolver: " + exceptionCodeResolverList.size()));
            for (ExceptionCodeResolver exceptionCodeResolver : exceptionCodeResolverList) {
                logger.debug((Object)("====== Find ExceptionCodeResolver: " + exceptionCodeResolver.getClass().toString()));
            }
        }
        return exceptionCodeResolverList;
    }

    private <T> Collection<T> getBeans(Class<T> type) {
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext.getBeanFactory(), type).values();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (applicationContext instanceof ConfigurableApplicationContext) {
            this.applicationContext = (ConfigurableApplicationContext)applicationContext;
        }
    }
}

