/*
 * Decompiled with CFR 0.152.
 */
package nexcore.sprout.spring.boot.autoconfigure.event;

import nexcore.sprout.foundry.event.SproutEventPublisher;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.boot.autoconfigure.web.WebMvcProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnProperty(prefix="sprout.event-publisher", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={ResourceProperties.class, WebMvcProperties.class})
@AutoConfigureOrder(value=0x7FFFFFFF)
public class EventAutoConfiguration
extends WebMvcConfigurerAdapter {
    private static final Log logger = LogFactory.getLog(EventAutoConfiguration.class);
    @Autowired
    private ResourceProperties resourceProperties;
    @Autowired
    private WebMvcProperties webMvcProperties;

    @Bean
    @ConditionalOnMissingBean(value={SproutEventPublisher.class})
    public SproutEventPublisher sproutEventPublisher() {
        SproutEventPublisher sproutEventPublisher = new SproutEventPublisher();
        logger.info((Object)("====== Creating Bean: " + sproutEventPublisher.getClass().toString()));
        return sproutEventPublisher;
    }

    @ConditionalOnBean(value={SproutEventPublisher.class})
    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.sproutEventPublisher()).addPathPatterns(new String[]{this.webMvcProperties.getStaticPathPattern()}).excludePathPatterns(this.resourceProperties.getStaticLocations());
        logger.info((Object)"====== Add Interceptor sproutEventPublisher");
    }
}

