package nexcore.sprout.spring.boot.autoconfigure.webmvc;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import org.springframework.boot.context.properties.ConfigurationProperties;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@ConfigurationProperties(prefix=SproutAutoConfigConst.PREFIX_SPROUT_MVC)
public class SproutWebMvcProperties {
	
	/**
	 * Locale 설정.
	 */
	private Locale defaultLocale = Locale.KOREA;
	/**
	 * Locale 파라미터.
	 */
	private String localeParamName = "locale";

	/** fragView Prefix */
	private String fragPrefix = "/WEB-INF/jsp/";
	/** fragView Suffix */
	private String fragSuffix = ".frag";
	/** Do View Prefix */
	private String doPrefix = "/WEB-INF/jsp/";
	/** Do View Suffix */
	private String doSuffix = ".do";
			
	private List<View> view = new ArrayList<View>();
	
	public String getFragPrefix() {
		return fragPrefix;
	}

	public void setFragPrefix(String fragPrefix) {
		this.fragPrefix = fragPrefix;
	}

	public String getFragSuffix() {
		return fragSuffix;
	}

	public void setFragSuffix(String fragSuffix) {
		this.fragSuffix = fragSuffix;
	}

	public String getDoPrefix() {
		return doPrefix;
	}

	public void setDoPrefix(String doPrefix) {
		this.doPrefix = doPrefix;
	}

	public String getDoSuffix() {
		return doSuffix;
	}

	public void setDoSuffix(String doSuffix) {
		this.doSuffix = doSuffix;
	}

	public Locale getDefaultLocale() {
		return defaultLocale;
	}

	public void setDefaultLocale(Locale defaultLocale) {
		this.defaultLocale = defaultLocale;
	}

	public String getLocaleParamName() {
		return localeParamName;
	}

	public void setLocaleParamName(String localeParamName) {
		this.localeParamName = localeParamName;
	}
	
	public List<View> getView() {
		return view;
	}

	public void setView(List<View> view) {
		this.view = view;
	}

	public static class View {

		/** View Controller */
		private String viewController;
		/** View Name */
		private String viewName;
		
		public String getViewController() {
			return viewController;
		}

		public void setViewController(String viewController) {
			this.viewController = viewController;
		}

		public String getViewName() {
			return viewName;
		}

		public void setViewName(String viewName) {
			this.viewName = viewName;
		}
		
	}
	
}
