package nexcore.sprout.spring.boot.autoconfigure.webmvc;

import org.springframework.boot.context.properties.ConfigurationProperties;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@ConfigurationProperties(prefix=SproutAutoConfigConst.PREFIX_SPROUT_MVC_DUPLICATE_SUBMIT_PREVENT)
public class DuplicatedSubmitPreventInterceptorProperties {

	/** SynchronizedToken가 없을때 false */
	private boolean ignoreNotFoundSynchronizedToken;
	/** TokenQueue 최대크기 */
	private int maxTokenQueueSize;
	/** 중복 체크 회피를 위한 Request Parameter key defaul value: "cs" */
	private String checkSkipParameterKey;
	/** Mapping Path Patterns  */
	private String[] pathPatterns = {"/**"};
	/** Mapping Exclude Path Patterns  */
	private String[] excludePatterns = {
			"classpath:/META-INF/resources/", "classpath:/resources/",
			"classpath:/static/", "classpath:/public/" };
	
	public boolean isIgnoreNotFoundSynchronizedToken() {
		return ignoreNotFoundSynchronizedToken;
	}
	
	public void setIgnoreNotFoundSynchronizedToken(boolean ignoreNotFoundSynchronizedToken) {
		this.ignoreNotFoundSynchronizedToken = ignoreNotFoundSynchronizedToken;
	}
	
	public int getMaxTokenQueueSize() {
		return maxTokenQueueSize;
	}
	
	public void setMaxTokenQueueSize(int maxTokenQueueSize) {
		this.maxTokenQueueSize = maxTokenQueueSize;
	}
	
	public String getCheckSkipParameterKey() {
		return checkSkipParameterKey;
	}
	
	public void setCheckSkipParameterKey(String checkSkipParameterKey) {
		this.checkSkipParameterKey = checkSkipParameterKey;
	}
	
	public String[] getPathPatterns() {
		return pathPatterns;
	}
	
	public void setPathPatterns(String[] pathPatterns) {
		this.pathPatterns = pathPatterns;
	}
	
	public String[] getExcludePatterns() {
		return excludePatterns;
	}
	
	public void setExcludePatterns(String[] excludePatterns) {
		this.excludePatterns = excludePatterns;
	}
	
}
