package nexcore.sprout.spring.boot.autoconfigure.webmvc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import nexcore.sprout.foundry.webmvc.interceptors.DuplicatedSubmitPreventInterceptor;
import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@Configuration
@ConditionalOnProperty(prefix = SproutAutoConfigConst.PREFIX_SPROUT_MVC_DUPLICATE_SUBMIT_PREVENT, name = "enabled", havingValue="true", matchIfMissing = true)
@AutoConfigureAfter(SproutWebMvcAutoConfiguration.class)
@ConditionalOnWebApplication
@AutoConfigureOrder(Ordered.LOWEST_PRECEDENCE - 10)
@EnableConfigurationProperties(DuplicatedSubmitPreventInterceptorProperties.class)
public class DuplicatedSubmitPreventInterceptorAutoConfiguration extends WebMvcConfigurerAdapter {
	
	private static final Log logger = LogFactory.getLog(DuplicatedSubmitPreventInterceptorAutoConfiguration.class);
	
	@Autowired
	DuplicatedSubmitPreventInterceptorProperties duplicatedSubmitPreventProperties ;
	
	@Bean
	@ConditionalOnMissingBean
	public DuplicatedSubmitPreventInterceptor duplicatedSubmitPreventInterceptor(){
		DuplicatedSubmitPreventInterceptor duplicatedSubmitPreventInterceptor = new DuplicatedSubmitPreventInterceptor();
		logger.info("====== Creating Bean: " + duplicatedSubmitPreventInterceptor.getClass().toString());
		if(duplicatedSubmitPreventProperties.getCheckSkipParameterKey() !=null){
			duplicatedSubmitPreventInterceptor.setCheckSkipParameterKey(duplicatedSubmitPreventProperties.getCheckSkipParameterKey());
		}
		if(!duplicatedSubmitPreventProperties.isIgnoreNotFoundSynchronizedToken()){
		duplicatedSubmitPreventInterceptor.setIgnoreNotFoundSynchronizedToken(duplicatedSubmitPreventProperties.isIgnoreNotFoundSynchronizedToken());
		}
		if(duplicatedSubmitPreventProperties.getMaxTokenQueueSize() > 0){
		duplicatedSubmitPreventInterceptor.setMaxTokenQueueSize(duplicatedSubmitPreventProperties.getMaxTokenQueueSize());
		}
		logger.info("====== CheckSkipParameterKey : "+ duplicatedSubmitPreventInterceptor.getCheckSkipParameterKey());
		logger.info("====== IgnoreNotFoundSynchronizedToken : "+ duplicatedSubmitPreventInterceptor.isIgnoreNotFoundSynchronizedToken());
		logger.info("====== MaxTokenQueueSize : " + duplicatedSubmitPreventInterceptor.getMaxTokenQueueSize());
		return duplicatedSubmitPreventInterceptor;
	}
	
	@Override
	@ConditionalOnBean(DuplicatedSubmitPreventInterceptor.class)
	public void addInterceptors(InterceptorRegistry registry) {
		registry.addInterceptor(this.duplicatedSubmitPreventInterceptor())
			.addPathPatterns(duplicatedSubmitPreventProperties.getPathPatterns())
			.excludePathPatterns(duplicatedSubmitPreventProperties.getExcludePatterns());
		logger.info("====== Add Interceptor duplicatedSubmitPreventInterceptor");
	}
	
}
