package nexcore.sprout.spring.boot.autoconfigure.webmvc;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import nexcore.sprout.foundry.webmvc.interceptors.CommonFieldSetter;
import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@Configuration
@ConditionalOnProperty(prefix = SproutAutoConfigConst.PREFIX_SPROUT_MVC_COMMON_FIELD_SETTER, name = "enabled", havingValue="true", matchIfMissing = true)
@AutoConfigureAfter(SproutWebMvcAutoConfiguration.class)
@ConditionalOnWebApplication
@AutoConfigureOrder(Ordered.LOWEST_PRECEDENCE - 20)
@EnableConfigurationProperties(CommonFieldSetterProperties.class)
public class CommonFieldSetterAutoConfiguration extends WebMvcConfigurerAdapter {
	
	private static final Log logger = LogFactory.getLog(CommonFieldSetterAutoConfiguration.class);
	
	@Autowired
	CommonFieldSetterProperties commonFieldSetterProperties ;
	
	@Bean
	@ConditionalOnMissingBean
	public CommonFieldSetter commonFieldSetter(){
		CommonFieldSetter commonFieldSetter = new CommonFieldSetter();
		logger.info("====== Creating Bean: " + commonFieldSetter.getClass().toString());
		
		if(commonFieldSetterProperties.getResultCodeFieldKeyName()!= null){
			commonFieldSetter.setResultCodeFieldKeyName(commonFieldSetterProperties.getResultCodeFieldKeyName());
		}
		
		if(commonFieldSetterProperties.getResultMessageFieldKeyName() != null ){
			commonFieldSetter.setResultMessageFieldKeyName(commonFieldSetterProperties.getResultMessageFieldKeyName());
		}
		
		if(commonFieldSetterProperties.getSuccessResultCode() != null ){
			commonFieldSetter.setSuccessResultCode(commonFieldSetterProperties.getSuccessResultCode());
		}
		
		if(!commonFieldSetterProperties.isSupportOildVersion()){
			commonFieldSetter.setSupportOildVersion(commonFieldSetterProperties.isSupportOildVersion());
		}
		
		logger.info("====== ResultCodeFieldKeyName : "+ commonFieldSetter.getResultCodeFieldKeyName());
		logger.info("====== ResultMessageFieldKeyName : "+ commonFieldSetter.getResultMessageFieldKeyName());
		logger.info("====== SuccessResultCode : " + commonFieldSetter.getSuccessResultCode());
		logger.info("====== SupportOildVersion : " + commonFieldSetter.isSupportOildVersion());
		
		return commonFieldSetter;
	}
	
	@Override
	@ConditionalOnBean(CommonFieldSetter.class)
	public void addInterceptors(InterceptorRegistry registry) {
		registry.addInterceptor(this.commonFieldSetter())
			.addPathPatterns(commonFieldSetterProperties.getPathPatterns())
			.excludePathPatterns(commonFieldSetterProperties.getExcludePatterns());
		logger.info("====== Add Interceptor commonFieldSetter");
	}

}
