package nexcore.sprout.spring.boot.autoconfigure.security;

import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnResource;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@Configuration
@ConditionalOnClass({ EnableWebSecurity.class, AuthenticationEntryPoint.class })
@ConditionalOnProperty(prefix = SproutAutoConfigConst.PREFIX_SPROUT_SECURITY_DB, name = "enabled", havingValue="true")
@EnableWebSecurity
@EnableConfigurationProperties({SproutSecurityProperties.class})
public class SproutSecurityByDbAutoConfiguration extends WebMvcConfigurerAdapter {
	
	@Configuration
	@ConditionalOnBean(name=SproutAutoConfigConst.DEFAULT_DATASOURCE_NAME)
	@ConditionalOnProperty(prefix = SproutAutoConfigConst.PREFIX_SPROUT_SECURITY_DB, name = "location")
	@ConditionalOnResource(resources="${sprout.security.core.location}")
	@ImportResource(locations = {"${sprout.security.db.location}", "${sprout.security.core.location}"})
	protected static class SproutSecurityAutoConfiguration {

	}

}