package nexcore.sprout.spring.boot.autoconfigure.resourcebundle;

import org.springframework.boot.context.properties.ConfigurationProperties;

import nexcore.sprout.spring.boot.autoconfigure.SproutAutoConfigConst;

@ConfigurationProperties(prefix = SproutAutoConfigConst.PREFIX_SPROUT_MESSAGE_RESOURCE, ignoreUnknownFields = false)
public class MessageSourceProperties {
	
	/*
	 * ReloadableResourceBundleMessageSource
	*/
    /** MessageSource 우선순위 */
	private int order;
    /** MessageSource 제목 */
	private String name;
    /** MessageSource 그룹 */
	private String group;
    /** MessageSource 파일경로 */
	private String basename;
    /** defaultEncoding */
	private String defaultEncoding;
    /** custom Basefile PostFix Name default : _ko_KR */
	private String defaultFilePostFix;
	/** custom Basefile 사용 여부 true 일 경우 fallbackToSystemLocale이 true 이더라도 fallbackfile을 추가 하지 않는 다. */
	private boolean useCustomDefaultFile;
	/** AutoReloading 사용 여부 */
	private boolean useAutoReloading;
	
	private long autoReloadingTime;
	
	private MessageDataSourceProperties messageDataSourceProperties = new MessageDataSourceProperties();
	
	public String getBasename() {
		return basename;
	}

	public void setBasename(String basename) {
		this.basename = basename;
	}

	public String getDefaultEncoding() {
		return defaultEncoding;
	}

	public void setDefaultEncoding(String defaultEncoding) {
		this.defaultEncoding = defaultEncoding;
	}

	public String getDefaultFilePostFix() {
		return defaultFilePostFix;
	}

	public void setDefaultFilePostFix(String defaultFilePostFix) {
		this.defaultFilePostFix = defaultFilePostFix;
	}

	public boolean isUseCustomDefaultFile() {
		return useCustomDefaultFile;
	}

	public void setUseCustomDefaultFile(boolean useCustomDefaultFile) {
		this.useCustomDefaultFile = useCustomDefaultFile;
	}

	public boolean isUseAutoReloading() {
		return useAutoReloading;
	}

	public void setUseAutoReloading(boolean useAutoReloading) {
		this.useAutoReloading = useAutoReloading;
	}

	public long getAutoReloadingTime() {
		return autoReloadingTime;
	}

	public void setAutoReloadingTime(long autoReloadingTime) {
		this.autoReloadingTime = autoReloadingTime;
	}
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getGroup() {
		return group;
	}

	public void setGroup(String group) {
		this.group = group;
	}

	public int getOrder() {
		return order;
	}

	public void setOrder(int order) {
		this.order = order;
	}
	
	public MessageDataSourceProperties getMessageDataSourceProperties() {
		return messageDataSourceProperties;
	}

	public void setMessageDataSourceProperties(MessageDataSourceProperties messageDataSourceProperties) {
		this.messageDataSourceProperties = messageDataSourceProperties;
	}

	/*
	 * DBReloadableResourceBundleMessageSource
	*/
	@ConfigurationProperties(prefix = SproutAutoConfigConst.PREFIX_SPROUT_MESSAGE_DATASOURCE, ignoreUnknownFields = false)
	public static class MessageDataSourceProperties {

	    /** MessageDataSource 사용 여부 default : false */
		private boolean enabled = false;
		
		private int order;
		
		private String name;
		
		private String group;
		
		private boolean fallbackToSystemLocale;
		
		private int cacheSeconds;
		
		private String queryCode;
		
		public boolean isEnabled() {
			return enabled;
		}

		public void setEnabled(boolean enabled) {
			this.enabled = enabled;
		}

		public int getOrder() {
			return order;
		}

		public void setOrder(int order) {
			this.order = order;
		}

		public String getName() {
			return name;
		}

		public void setName(String name) {
			this.name = name;
		}

		public String getGroup() {
			return group;
		}

		public void setGroup(String group) {
			this.group = group;
		}

		public boolean isFallbackToSystemLocale() {
			return fallbackToSystemLocale;
		}

		public void setFallbackToSystemLocale(boolean fallbackToSystemLocale) {
			this.fallbackToSystemLocale = fallbackToSystemLocale;
		}

		public int getCacheSeconds() {
			return cacheSeconds;
		}

		public void setCacheSeconds(int cacheSeconds) {
			this.cacheSeconds = cacheSeconds;
		}

		public String getQueryCode() {
			return queryCode;
		}

		public void setQueryCode(String queryCode) {
			this.queryCode = queryCode;
		}
		
	}
	
}