package nexcore.sprout.spring.boot.autoconfigure.resourcebundle;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.MessageSourceAccessor;

@Configuration
@ConditionalOnBean(MessageSource.class)
public class MessageSourceAccessorAutoConfiguration implements ApplicationContextAware {
	
	private static final Log logger = LogFactory.getLog(MessageSourceAccessorAutoConfiguration.class);
	
	@Autowired
	private ApplicationContext applicationContext;
	
	@Bean	
	@ConditionalOnMissingBean(MessageSourceAccessor.class)
	public MessageSourceAccessor messageSourceAccessor() {
		try {
			MessageSource messageSource = this.applicationContext.getBean("messageSource", MessageSource.class);
			MessageSourceAccessor messageSourceAccessor = new MessageSourceAccessor(messageSource);
			
			logger.info("====== Creating MessageSourceAccessor Bean: " + messageSourceAccessor.getClass().toString());
			logger.info("====== MessageSource for MessageSourceAccessor: " + messageSource.getClass().toString());
			return messageSourceAccessor;
		} catch (NullPointerException e) {
			logger.info("====== MessageSource is not exist.");
			logger.info("====== MessageSourceAccessor is not created.");
			return null;
		}
	}
	
	public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
		if (applicationContext instanceof ConfigurableApplicationContext) {
			this.applicationContext = (ConfigurableApplicationContext) applicationContext;
		}
	}

}
